/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.text.MessageFormat;
import java.util.Map;
import java.util.TimerTask;

public class DumpThreadTask
extends TimerTask {
    private final String testName;
    private final Thread testThread;

    public DumpThreadTask(String testName) {
        this.testName = testName;
        this.testThread = Thread.currentThread();
    }

    @Override
    public void run() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("Test {0} is taking too long:\n", this.testName));
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
            sb.append(entry.getKey().toString());
            sb.append("\n");
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                sb.append("  ");
                sb.append(element.toString());
                sb.append("\n");
                ++n2;
            }
            sb.append("\n");
        }
        System.err.println(sb.toString());
        System.err.println("Sending interrupt to thread: " + this.testThread.toString());
        this.testThread.interrupt();
    }
}

