/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

public class JavaCodeAnalyzer {
    private String complianceLevel = "1.6";

    public JavaParseResult<? extends ASTNode> determinateJavaType(String javaCode) {
        return this.determinateJavaType(javaCode, this.complianceLevel);
    }

    public JavaParseResult<? extends ASTNode> determinateJavaType(String javaCode, String compilerCompliance) {
        ASTNode _createAST_2;
        ASTNode _createAST_1;
        boolean _greaterThan;
        ASTParser parser = this.createDefaultJavaParser(compilerCompliance);
        char[] _charArray = javaCode.toCharArray();
        parser.setSource(_charArray);
        parser.setStatementsRecovery(true);
        ASTNode _createAST = parser.createAST(null);
        CompilationUnit unit = (CompilationUnit)_createAST;
        List _types = unit.types();
        int _size = _types.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            List<CompilationUnit> _singletonList = Collections.singletonList(unit);
            return new JavaParseResult<CompilationUnit>(javaCode, 8, _singletonList);
        }
        char[] _charArray_1 = javaCode.toCharArray();
        parser.setSource(_charArray_1);
        parser.setStatementsRecovery(false);
        parser.setKind(4);
        ASTNode root = parser.createAST(null);
        if (root instanceof TypeDeclaration) {
            boolean _greaterThan_1;
            List bodyDeclarations = ((TypeDeclaration)root).bodyDeclarations();
            int _size_1 = bodyDeclarations.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                return new JavaParseResult(javaCode, 4, bodyDeclarations);
            }
        }
        char[] _charArray_2 = javaCode.toCharArray();
        parser.setSource(_charArray_2);
        parser.setStatementsRecovery(false);
        parser.setKind(2);
        root = _createAST_1 = parser.createAST(null);
        if (root instanceof Block) {
            boolean _greaterThan_2;
            List statements = ((Block)root).statements();
            int _size_2 = statements.size();
            boolean bl3 = _greaterThan_2 = _size_2 > 0;
            if (_greaterThan_2) {
                return new JavaParseResult(javaCode, 2, statements);
            }
        }
        char[] _charArray_3 = javaCode.toCharArray();
        parser.setSource(_charArray_3);
        parser.setStatementsRecovery(false);
        parser.setKind(1);
        root = _createAST_2 = parser.createAST(null);
        if (root instanceof Expression) {
            List<Expression> _singletonList_1 = Collections.singletonList((Expression)root);
            return new JavaParseResult<Expression>(javaCode, 1, _singletonList_1);
        }
        return null;
    }

    public ASTParser createDefaultJavaParser() {
        return this.createDefaultJavaParser(this.complianceLevel);
    }

    public ASTParser createDefaultJavaParser(String compilerCompliance) {
        int _asJLS = JavaCodeAnalyzer.asJLS(compilerCompliance);
        ASTParser parser = ASTParser.newParser((int)_asJLS);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)compilerCompliance, (Map)options);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions((Map)options);
        return parser;
    }

    public static int asJLS(String compilerCompliance) {
        int _switchResult = 0;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)compilerCompliance, (Object)"1.7")) {
            _matched = true;
            _switchResult = 4;
        }
        if (!_matched && Objects.equal((Object)compilerCompliance, (Object)"1.8")) {
            _matched = true;
            _switchResult = 8;
        }
        if (!_matched) {
            _switchResult = 3;
        }
        return _switchResult;
    }

    @Accessors(value={AccessorType.PUBLIC_GETTER})
    public static final class JavaParseResult<T extends ASTNode> {
        private String javaCode;
        private List<T> nodes;
        private int type;

        public JavaParseResult(String javaCode, int type, List<T> nodes) {
            this.javaCode = javaCode;
            this.type = type;
            this.nodes = nodes;
        }

        @Pure
        public String getJavaCode() {
            return this.javaCode;
        }

        @Pure
        public List<T> getNodes() {
            return this.nodes;
        }

        @Pure
        public int getType() {
            return this.type;
        }
    }
}

