/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.common;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.common.AbstractAtlSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlLibrarySelection
extends AbstractAtlSelection {
    private static final String DEFAULT_NAME = "LIB";
    private Text libraryNameText;
    private Map<String, String> librariesFromParent;

    public AtlLibrarySelection(Shell parent, String title, Map<String, String> libraries) {
        super(parent, title);
        this.librariesFromParent = libraries;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.libraryNameText.getText()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        Group namingSection = new Group(container, 0);
        namingSection.setText(Messages.getString("AtlLibrarySelection.NAMING"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        namingSection.setLayout((Layout)layout);
        data = new GridData(768);
        namingSection.setLayoutData((Object)data);
        new Label((Composite)namingSection, 0).setText(Messages.getString("AtlLibrarySelection.LIBRARY_NAME"));
        this.libraryNameText = new Text((Composite)namingSection, 2048);
        this.libraryNameText.setLayoutData((Object)new GridData(768));
        this.libraryNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlLibrarySelection.this.textChanged();
            }
        });
        return container;
    }

    @Override
    public void create() {
        super.create();
        this.libraryNameText.setText(this.getDefaultName(DEFAULT_NAME, this.librariesFromParent.keySet()));
        this.libraryNameText.selectAll();
    }

    private void textChanged() {
        String message = this.checkText(this.libraryNameText.getText());
        if (message != null) {
            this.nok(message);
        } else {
            this.ok();
        }
    }

    private String checkText(String text) {
        if (text == null || "".equals(text)) {
            return Messages.getString("AtlLibrarySelection.SET_NAME");
        }
        if (!text.matches("[a-zA-Z0-9]+")) {
            return Messages.getString("AtlLibrarySelection.INVALID_NAME");
        }
        if (this.librariesFromParent.containsKey(text)) {
            return Messages.getString("AtlLibrarySelection.LIBRARY_EXISTS");
        }
        return null;
    }
}

