/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ga extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Meán-Am Greenwich",
               "MAG",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Am Caighdeánach Acre",
               "",
               "Am Samhraidh Acre",
               "",
               "Am Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Am Caighdeánach Apia",
               "",
               "Am Samhraidh Apia",
               "",
               "Am Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Am Caighdeánach Oileáin Cook",
               "",
               "Am Leathshamhraidh Oileáin Cook",
               "",
               "Am Oileáin Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Am Caighdeánach Chúba",
               "CST",
               "Am Samhraidh Chúba",
               "CDT",
               "Am Chúba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Am Caighdeánach Fhidsí",
               "",
               "Am Samhraidh Fhidsí",
               "",
               "Am Fhidsí",
               "",
            };
        final String[] Gulf = new String[] {
               "Am Caighdeánach na Murascaille",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Am Caighdeánach Hovd",
               "",
               "Am Samhraidh Hovd",
               "",
               "Am Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Am Caighdeánach na hIaráine",
               "",
               "Am Samhraidh na hIaráine",
               "",
               "Am na hIaráine",
               "",
            };
        final String[] Niue = new String[] {
               "Am Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Am Caighdeánach Omsk",
               "",
               "Am Samhraidh Omsk",
               "",
               "Am Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Am Caighdeánach Pheiriú",
               "",
               "Am Samhraidh Pheiriú",
               "",
               "Am Pheiriú",
               "",
            };
        final String[] Truk = new String[] {
               "Am Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Am Oileán Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Am Caighdeánach na Sile",
               "",
               "Am Samhraidh na Sile",
               "",
               "Am na Sile",
               "",
            };
        final String[] China = new String[] {
               "Am Caighdeánach na Síne",
               "CST",
               "Am Samhraidh na Síne",
               "CDT",
               "Am na Síne",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Am Oileáin Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Am Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Am Caighdeánach na hIndia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Am Caighdeánach na Seapáine",
               "JST",
               "Am Samhraidh na Seapáine",
               "JDT",
               "Am na Seapáine",
               "JT",
            };
        final String[] Korea = new String[] {
               "Am Caighdeánach na Cóiré",
               "KST",
               "Am Samhraidh na Cóiré",
               "KST",
               "Am na Cóiré",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Am Nárú",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Am Neipeal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Am Oileáin Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Am Caighdeánach Shamó",
               "SST",
               "Am Samhraidh Shamó",
               "SST",
               "Am Shamó",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Am Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Am Caighdeánach Thonga",
               "",
               "Am Samhraidh Thonga",
               "",
               "Am Thonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Am Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Am Caighdeánach Alasca",
               "AKST",
               "Am Samhraidh Alasca",
               "AKDT",
               "Am Alasca",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Am Caighdeánach na hAmasóine",
               "",
               "Am Samhraidh na hAmasóine",
               "",
               "Am na hAmasóine",
               "",
            };
        final String[] Anadyr = new String[] {
               "Am Caighdeánach Anadyr",
               "",
               "Am Samhraidh Anadyr",
               "",
               "Am Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Am Caighdeánach na nAsór",
               "",
               "Am Samhraidh na nAsór",
               "",
               "Am na nAsór",
               "",
            };
        final String[] Bhutan = new String[] {
               "Am na Bútáine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Am Bhrúiné Darasalám",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Am Caighdeánach Oileán na Cásca",
               "",
               "Am Samhraidh Oileán na Cásca",
               "",
               "Am Oileán na Cásca",
               "",
            };
        final String[] Guyana = new String[] {
               "Am na Guáine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Am Caighdeánach Iosrael",
               "IST",
               "Am Samhraidh Iosrael",
               "IDT",
               "Am Iosrael",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Am Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Am Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Am Caighdeánach Mhoscó",
               "MSK",
               "Am Samhraidh Mhoscó",
               "MSK",
               "Am Mhoscó",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Am Phohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Am Caighdeánach Shamara",
               "",
               "Am Samhraidh Shamara",
               "",
               "Am Shamara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Am Thaihítí",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Am Caighdeánach Taipei",
               "CST",
               "Am Samhraidh Taipei",
               "CDT",
               "Am Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Am Thúvalú",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Am Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Am Wallis agus Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Am Caighdeánach na hAraibe",
               "",
               "Am Samhraidh na hAraibe",
               "",
               "Am na hAraibe",
               "",
            };
        final String[] Armenia = new String[] {
               "Am Caighdeánach na hAirméine",
               "",
               "Am Samhraidh na hAirméine",
               "",
               "Am na hAirméine",
               "",
            };
        final String[] Bolivia = new String[] {
               "Am na Bolaive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Am Caighdeánach Chatham",
               "",
               "Am Samhraidh Chatham",
               "",
               "Am Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Am Uilíoch Lárnach",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Am Eacuadór",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Am Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Am Caighdeánach na Seoirsia",
               "",
               "Am Samhraidh na Seoirsia",
               "",
               "Am na Seoirsia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Am Caighdeánach Irkutsk",
               "",
               "Am Samhraidh Irkutsk",
               "",
               "Am Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Am Caighdeánach Mhagadan",
               "",
               "Am Samhraidh Mhagadan",
               "",
               "Am Mhagadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Am Mhaenmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Am Caighdeánach Oileán Norfolk",
               "",
               "Am Samhraidh Oileán Norfolk",
               "",
               "Am Oileán Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Am Caighdeánach Fernando de Noronha",
               "",
               "Am Samhraidh Fernando de Noronha",
               "",
               "Am Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Am Réunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Am Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Am Oileáin Sholaimh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Am Oileáin Tócalá",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Am Caighdeánach Uragua",
               "",
               "Am Samhraidh Uragua",
               "",
               "Am Uragua",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Am Caighdeánach Vanuatú",
               "",
               "Am Samhraidh Vanuatú",
               "",
               "Am Vanuatú",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Am Caighdeánach Iacútsc",
               "",
               "Am Samhraidh Iacútsc",
               "",
               "Am Iacútsc",
               "",
            };
        final String[] Atlantic = new String[] {
               "Am Caighdeánach an Atlantaigh",
               "AST",
               "Am Samhraidh an Atlantaigh",
               "AST",
               "Am an Atlantaigh",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Am Caighdeánach Bhrasília",
               "",
               "Am Samhraidh Bhrasília",
               "",
               "Am Bhrasília",
               "",
            };
        final String[] Chamorro = new String[] {
               "Am Caighdeánach Seamórach",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Am Caighdeánach na Colóime",
               "",
               "Am Samhraidh na Colóime",
               "",
               "Am na Colóime",
               "",
            };
        final String[] Falkland = new String[] {
               "Am Caighdeánach Oileáin Fháclainne",
               "",
               "Am Samhraidh Oileáin Fháclainne",
               "",
               "Am Oileáin Fháclainne",
               "",
            };
        final String[] Malaysia = new String[] {
               "Am na Malaeisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Am Oileáin Mhaildíve",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Am Caighdeánach Ulánbátar",
               "",
               "Am Samhraidh Ulánbátar",
               "",
               "Am Ulánbátar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Am Caighdeánach na Pacastáine",
               "PKT",
               "Am Samhraidh na Pacastáine",
               "PKST",
               "Am na Pacastáine",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Am Caighdeánach Pharagua",
               "",
               "Am Samhraidh Pharagua",
               "",
               "Am Pharagua",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Am Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Am Caighdeánach Shacailín",
               "",
               "Am Samhraidh Shacailín",
               "",
               "Am Shacailín",
               "",
            };
        final String[] Suriname = new String[] {
               "Am Shuranam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Am Caighdeánach na hAirgintíne",
               "",
               "Am Samhraidh na hAirgintíne",
               "",
               "Am na hAirgintíne",
               "",
            };
        final String[] Christmas = new String[] {
               "Am Oileán na Nollag",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Am Oileáin Galápagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Am Caighdeánach Hong Cong",
               "HKT",
               "Am Samhraidh Hong Cong",
               "HKST",
               "Am Hong Cong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Am na hInd-Síne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Am Caighdeánach Phetropavlovsk-Kamchatski",
               "",
               "Am Samhraidh Phetropavlovsk-Kamchatski",
               "",
               "Am Phetropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Am na Cirgeastáine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Am Caighdeánach Lord Howe",
               "",
               "Am Samhraidh Lord Howe",
               "",
               "Am Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Am na nOileán Marcasach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Am Caighdeánach Oileán Mhuirís",
               "",
               "Am Samhraidh Oileán Mhuirís",
               "",
               "Am Oileán Mhuirís",
               "",
            };
        final String[] Singapore = new String[] {
               "Am Caighdeánach Shingeapór",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Am Veiniséala",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Am Caighdeánach Volgograd",
               "MSK",
               "Am Samhraidh Volgograd",
               "MSK",
               "Am Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Am Caighdeánach na hAsarbaiseáine",
               "",
               "Am Samhraidh na hAsarbaiseáine",
               "",
               "Am na hAsarbaiseáine",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Am Caighdeánach na Banglaidéise",
               "",
               "Am Samhraidh na Banglaidéise",
               "",
               "Am na Banglaidéise",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Am Caighdeánach Rinn Verde",
               "",
               "Am Samhraidh Rinn Verde",
               "",
               "Am Rinn Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Am Thíomór Thoir",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Am na Casacstáine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Am na Séiséal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Am na Táidsíceastáine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Am Caighdeánach na hÚisbéiceastáine",
               "",
               "Am Samhraidh na hÚisbéiceastáine",
               "",
               "Am na hÚisbéiceastáine",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Am na hAfganastáine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Am Caighdeánach Krasnoyarsk",
               "",
               "Am Samhraidh Krasnoyarsk",
               "",
               "Am Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Am Caighdeánach na Nua-Shéalainne",
               "NZST",
               "Am Samhraidh na Nua-Shéalainne",
               "NZDT",
               "Am na Nua-Shéalainne",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Am Caighdeánach Novosibirsk",
               "",
               "Am Samhraidh Novosibirsk",
               "",
               "Am Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Am Caighdeánach na nOileán Filipíneach",
               "PST",
               "Am Samhraidh na nOileán Filipíneach",
               "PDT",
               "Am na nOileán Filipíneach",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Am Caighdeánach Vladivostok",
               "",
               "Am Samhraidh Vladivostok",
               "",
               "Am Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Am an Aigéin Indiaigh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Am Oileáin na Líne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Am Caighdeánach Thalamh an Éisc",
               "NST",
               "Am Samhraidh Thalamh an Éisc",
               "NDT",
               "Am Thalamh an Éisc",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Am Caighdeánach na Tuircméanastáine",
               "",
               "Am Samhraidh na Tuircméanastáine",
               "",
               "Am na Tuircméanastáine",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Am Ghuáin na Fraince",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Am Caighdeánach na Nua-Chaladóine",
               "",
               "Am Samhraidh na Nua-Chaladóine",
               "",
               "Am na Nua-Chaladóine",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Am na Seoirsia Theas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Am Caighdeánach Yekaterinburg",
               "",
               "Am Samhraidh Yekaterinburg",
               "",
               "Am Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Am na hAfraice Láir",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Am Oirthear na hAfraice",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Am Caighdeánach Iarthar na hAfraice",
               "WAT",
               "Am Samhraidh Iarthar na hAfraice",
               "WAT",
               "Am Iarthar na hAfraice",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Am Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Am Caighdeánach Lár na hEorpa",
               "CET",
               "Am Samhraidh Lár na hEorpa",
               "CEST",
               "Am Lár na hEorpa",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Am Caighdeánach Oirthear na hEorpa",
               "EET",
               "Am Samhraidh Oirthear na hEorpa",
               "EEST",
               "Am Oirthear na hEorpa",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Am Caighdeánach Iarthar na hEorpa",
               "WET",
               "Am Samhraidh Iarthar na hEorpa",
               "WEST",
               "Am Iarthar na hEorpa",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Am Caighdeánach Meicsiceach an Aigéin Chiúin",
               "MST",
               "Am Samhraidh Meicsiceach an Aigéin Chiúin",
               "MDT",
               "Am Meicsiceach an Aigéin Chiúin",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Am na hAfraice Theas",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Am Caighdeánach Lárnach Mheiriceá Thuaidh",
               "CST",
               "Am Samhraidh Lárnach Mheiriceá Thuaidh",
               "CDT",
               "Am Lárnach Mheiriceá Thuaidh",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Am Caighdeánach Oirthearach Mheiriceá Thuaidh",
               "EST",
               "Am Samhraidh Oirthearach Mheiriceá Thuaidh",
               "EST",
               "Am Oirthearach Mheiriceá Thuaidh",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Am Caighdeánach an Aigéin Chiúin",
               "ACAC",
               "Am Samhraidh an Aigéin Chiúin",
               "ASAC",
               "Am an Aigéin Chiúin",
               "AAC",
            };
        final String[] French_Southern = new String[] {
               "Am Francach Dheisceart an Domhain agus an Antartaigh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Am Chireabaití",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Am Caighdeánach Haváí-Ailiúit",
               "HST",
               "Am Samhraidh Haváí-Ailiúit",
               "HST",
               "Am Haváí-Ailiúit",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Am Oileáin an Fhéinics",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Am Caighdeánach Saint-Pierre-et-Miquelon",
               "",
               "Am Samhraidh Saint-Pierre-et-Miquelon",
               "",
               "Am Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Am Caighdeánach Sléibhte Mheiriceá Thuaidh",
               "MST",
               "Am Samhraidh Sléibhte Mheiriceá Thuaidh",
               "MST",
               "Am Sléibhte Mheiriceá Thuaidh",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Am Oileáin Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Am Nua-Ghuine Phapua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Am Caighdeánach Lár na hAstráile",
               "ACST",
               "Am Samhraidh Lár na hAstráile",
               "ACDT",
               "Am Lár na hAstráile",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Am Caighdeánach Oirthear na hAstráile",
               "AEST",
               "Am Samhraidh Oirthear na hAstráile",
               "AEDT",
               "Am Oirthear na hAstráile",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Am Caighdeánach Iarthar na hAstráile",
               "AWST",
               "Am Samhraidh Iarthar na hAstráile",
               "AWDT",
               "Am Iarthar na hAstráile",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Am Lár na hIndinéise",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Am Oirthear na hIndinéise",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Am Iarthar na hIndinéise",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Am Caighdeánach Mheániarthar na hAstráile",
               "",
               "Am Samhraidh Mheániarthar na hAstráile",
               "",
               "Am Mheániarthar na hAstráile",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Am Uilíoch Lárnach",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Caighdéanach na hÉireann",
                    "ACÉ",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Am Uilíoch Lárnach",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Am Uilíoch Lárnach",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Am Uilíoch Lárnach",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Am Uilíoch Lárnach",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Am Uilíoch Lárnach",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Caighdéanach na hÉireann",
                    "ACÉ",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Meán-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Áidin" },
            { "timezone.excity.Asia/Baku", "Baki" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Kabul", "Cabúl" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Súl" },
            { "timezone.excity.Asia/Tokyo", "Tóiceo" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lomé" },
            { "timezone.excity.Asia/Beirut", "Béiriút" },
            { "timezone.excity.Asia/Brunei", "Brúiné" },
            { "timezone.excity.Asia/Hebron", "Heabrón" },
            { "timezone.excity.Asia/Kuwait", "Cuáit" },
            { "timezone.excity.Asia/Manila", "Mainile" },
            { "timezone.excity.Asia/Saigon", "Cathair Ho Chi Minh" },
            { "timezone.excity.Etc/Unknown", "Cathair Anaithnid" },
            { "timezone.excity.Europe/Kiev", "Cív" },
            { "timezone.excity.Europe/Oslo", "Osló" },
            { "timezone.excity.Europe/Riga", "Ríge" },
            { "timezone.excity.Europe/Rome", "an Róimh" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Caireo" },
            { "timezone.excity.Africa/Dakar", "Dacár" },
            { "timezone.excity.Africa/Tunis", "Túinis" },
            { "timezone.excity.America/Lima", "Líoma" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bairéin" },
            { "timezone.excity.Asia/Jakarta", "Iacárta" },
            { "timezone.excity.Asia/Nicosia", "an Niocóis" },
            { "timezone.excity.Asia/Rangoon", "Rangún" },
            { "timezone.excity.Asia/Yakutsk", "Iacútsc" },
            { "timezone.excity.Asia/Yerevan", "Eireaván" },
            { "timezone.excity.Europe/Malta", "Málta" },
            { "timezone.excity.Europe/Minsk", "Mionsc" },
            { "timezone.excity.Europe/Paris", "Páras" },
            { "timezone.excity.Europe/Sofia", "Sóifia" },
            { "timezone.excity.Europe/Vaduz", "Vadús" },
            { "timezone.excity.Indian/Cocos", "Oileán Cocos" },
            { "timezone.excity.Pacific/Fiji", "Fidsí" },
            { "timezone.excity.Africa/Maputo", "Mapútó" },
            { "timezone.excity.America/Aruba", "Arúba" },
            { "timezone.excity.America/Belem", "Belém" },
            { "timezone.excity.America/Thule", "Inis Tuile" },
            { "timezone.excity.Asia/Calcutta", "Calcúta" },
            { "timezone.excity.Asia/Damascus", "an Damaisc" },
            { "timezone.excity.Asia/Makassar", "Macasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Shanghai", "Shang-hai" },
            { "timezone.excity.Europe/Athens", "an Aithin" },
            { "timezone.excity.Europe/Berlin", "Beirlín" },
            { "timezone.excity.Europe/Dublin", "Baile Átha Cliath" },
            { "timezone.excity.Europe/Jersey", "Geirsí" },
            { "timezone.excity.Europe/Lisbon", "Liospóin" },
            { "timezone.excity.Europe/London", "Londain" },
            { "timezone.excity.Europe/Madrid", "Maidrid" },
            { "timezone.excity.Europe/Monaco", "Monacó" },
            { "timezone.excity.Europe/Moscow", "Moscó" },
            { "timezone.excity.Europe/Prague", "Prág" },
            { "timezone.excity.Europe/Skopje", "Scóipé" },
            { "timezone.excity.Europe/Tirane", "Tiorána" },
            { "timezone.excity.Europe/Vienna", "Vín" },
            { "timezone.excity.Europe/Warsaw", "Vársá" },
            { "timezone.excity.Europe/Zagreb", "Ságrab" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "timezone.excity.Indian/Comoro", "Oileáin Chomóra" },
            { "timezone.excity.Pacific/Nauru", "Nárú" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Cathair na hAilgéire" },
            { "timezone.excity.Africa/Conakry", "Conacraí" },
            { "timezone.excity.Africa/Tripoli", "Tripilí" },
            { "timezone.excity.America/Belize", "an Bheilís" },
            { "timezone.excity.America/Bogota", "Bogatá" },
            { "timezone.excity.America/Guyana", "an Ghuáin" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Cong" },
            { "timezone.excity.Asia/Jerusalem", "Iarúsailéim" },
            { "timezone.excity.Asia/Singapore", "Singeapór" },
            { "timezone.excity.Europe/Andorra", "Andóra" },
            { "timezone.excity.Europe/Tallinn", "Taillinn" },
            { "timezone.excity.Europe/Vatican", "an Vatacáin" },
            { "timezone.excity.Europe/Vilnius", "Vilnias" },
            { "timezone.excity.Indian/Reunion", "La Réunion" },
            { "timezone.excity.Pacific/Midway", "Oileáin Midway" },
            { "timezone.excity.Pacific/Tahiti", "Taihítí" },
            { "timezone.excity.Pacific/Wallis", "Vailís" },
            { "timezone.excity.Africa/El_Aaiun", "Láúine" },
            { "timezone.excity.Africa/Khartoum", "Cartúm" },
            { "timezone.excity.America/Cordoba", "Córdoba" },
            { "timezone.excity.America/Curacao", "Cúrasó" },
            { "timezone.excity.America/Grenada", "Greanáda" },
            { "timezone.excity.America/Jamaica", "Iamáice" },
            { "timezone.excity.Atlantic/Azores", "na hAsóir" },
            { "timezone.excity.Atlantic/Canary", "na hOileáin Chanáracha" },
            { "timezone.excity.Atlantic/Faeroe", "Oileáin Fharó" },
            { "timezone.excity.Europe/Belgrade", "Béalgrád" },
            { "timezone.excity.Europe/Brussels", "an Bhruiséil" },
            { "timezone.excity.Europe/Budapest", "Búdaipeist" },
            { "timezone.excity.Europe/Chisinau", "Císineá" },
            { "timezone.excity.Europe/Guernsey", "Geansaí" },
            { "timezone.excity.Europe/Helsinki", "Heilsincí" },
            { "timezone.excity.Europe/Istanbul", "Iostanbúl" },
            { "timezone.excity.Europe/Sarajevo", "Sairéavó" },
            { "timezone.excity.Indian/Maldives", "Oileáin Mhaildíve" },
            { "timezone.excity.Africa/Mogadishu", "Mogaidisiú" },
            { "timezone.excity.America/Anguilla", "Angaíle" },
            { "timezone.excity.America/Barbados", "Barbadós" },
            { "timezone.excity.America/Dominica", "Doiminice" },
            { "timezone.excity.America/New_York", "Nua-Eabhrac" },
            { "timezone.excity.America/St_Kitts", "San Críostóir" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Atlantic/Bermuda", "Beirmiúda" },
            { "timezone.excity.Atlantic/Madeira", "Maidéara" },
            { "timezone.excity.Europe/Amsterdam", "Amstardam" },
            { "timezone.excity.Europe/Astrakhan", "an Astracáin" },
            { "timezone.excity.Europe/Bucharest", "Búcairist" },
            { "timezone.excity.Europe/Gibraltar", "Giobráltar" },
            { "timezone.excity.Europe/Ljubljana", "Liúibleána" },
            { "timezone.excity.Europe/Podgorica", "Podgairítse" },
            { "timezone.excity.Europe/Stockholm", "Stócólm" },
            { "timezone.excity.Indian/Christmas", "Oileán na Nollag" },
            { "timezone.excity.Indian/Mauritius", "Oileán Mhuirís" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Nouakchott", "Nuacsat" },
            { "timezone.excity.America/Guatemala", "Guatamala" },
            { "timezone.excity.America/Sao_Paulo", "São Paulo" },
            { "timezone.excity.Europe/Bratislava", "an Bhratasláiv" },
            { "timezone.excity.Europe/Copenhagen", "Cóbanhávan" },
            { "timezone.excity.Europe/Luxembourg", "Lucsamburg" },
            { "timezone.excity.Europe/San_Marino", "San Mairíne" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "na hOileáin Mharcasacha" },
            { "timezone.excity.America/Costa_Rica", "Cósta Ríce" },
            { "timezone.excity.America/Guadeloupe", "Guadalúip" },
            { "timezone.excity.America/Montserrat", "Montsarat" },
            { "timezone.excity.America/St_Vincent", "San Uinseann" },
            { "timezone.excity.Atlantic/Reykjavik", "Réicivíc" },
            { "timezone.excity.Atlantic/St_Helena", "San Héilin" },
            { "timezone.excity.Europe/Isle_of_Man", "Oileán Mhanann" },
            { "timezone.excity.America/El_Salvador", "an tSalvadóir" },
            { "timezone.excity.America/Mexico_City", "Cathair Mheicsiceo" },
            { "timezone.excity.America/Puerto_Rico", "Pórtó Ríce" },
            { "timezone.excity.Atlantic/Cape_Verde", "Rinn Verde" },
            { "timezone.excity.Indian/Antananarivo", "Antananairíveo" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dárasalám" },
            { "timezone.excity.Antarctica/Macquarie", "Mac Guaire" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthélemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "an tSeoirsia Theas" },
        };
        return data;
    }
}
