/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSBuildListener;
import com.sun.ant.TSLogger;
import com.sun.ant.taskdefs.common.ArchiveInfo;
import com.sun.ant.taskdefs.common.CompatHelper;
import com.sun.ant.taskdefs.common.TSVehicles;
import com.sun.ant.taskdefs.common.TaskUtil;
import com.sun.ant.taskdefs.ejb.EJBJar;
import com.sun.ant.taskdefs.web.WebWar;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.FileUtils;

public class ContainerPackage
extends Task
implements TaskContainer {
    private List nestedTasks = new ArrayList();
    public static final byte COMPILE_LEVEL = 1;
    public static final byte COMPONENT_LEVEL = 2;
    public static final byte APPLICATION_LEVEL = 3;
    static byte buildLevel;
    private TSVehicles vehiclesTask;
    private static List builtCommonApps;
    private static ClassLoader deliverableClassLoader;
    private File srcDir;
    private File distDir;
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void myinit() {
        block7: {
            this.srcDir = TaskUtil.getCurrentSrcDir(this.project);
            this.distDir = TaskUtil.getFullDistDir(this.srcDir, this.project);
            if (buildLevel != 0) {
                return;
            }
            String sLevel = this.project.getProperty("build.level");
            if (sLevel == null) {
                sLevel = System.getProperty("build.level");
            }
            if (sLevel != null) {
                try {
                    sLevel = sLevel.trim();
                    buildLevel = Byte.parseByte(sLevel);
                    if (buildLevel != 1 && buildLevel != 2 && buildLevel != 3) {
                        buildLevel = (byte)3;
                        this.log("Invalid build.level " + sLevel + ". Set to default " + 3);
                        break block7;
                    }
                    this.log("build level is set to " + String.valueOf(buildLevel) + ". (1-compile only; 2-compile and build jar and war; 3-application archives.", 3);
                }
                catch (NumberFormatException nex) {
                    this.log("WARNING: Could not parse build.level.  Set to default 3");
                    buildLevel = (byte)3;
                }
            } else {
                buildLevel = (byte)3;
                this.log("build.level from project property and system property is null.  Set to default application level.");
            }
        }
    }

    public void execute() {
        try {
            this.myinit();
            if (buildLevel == 1 || this.nestedTasks.size() == 0) {
                return;
            }
            if (!TSBuildListener.skipMakeupCompile()) {
                // empty if block
            }
            int n = this.nestedTasks.size();
            for (int i = 0; i < n; ++i) {
                Task nestedTask = (Task)this.nestedTasks.get(i);
                if (buildLevel == 2) {
                    if (nestedTask.getTaskName().equals("appear")) continue;
                    nestedTask.perform();
                    continue;
                }
                nestedTask.perform();
            }
            if (this.vehiclesTask == null) {
                this.copyRuntime();
            }
            this.removeJarWar();
            if (TaskUtil.isCompatDir(this.srcDir)) {
                CompatHelper.copyArchivesToSrc(this.distDir, this.srcDir, this.project);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            TSLogger.addFailedDir(this.srcDir.getPath());
        }
    }

    private void removeJarWar() {
        if (buildLevel == 3) {
            File[] jarwars = this.distDir.listFiles(ArchiveInfo.jarWarFilter);
            if (jarwars == null) {
                if (this.vehiclesTask.isStandAlone) {
                    return;
                }
                throw new BuildException("distDir does not exist: " + this.distDir.getPath());
            }
            for (int i = 0; i < jarwars.length; ++i) {
                String fileName = jarwars[i].getName();
                if (fileName.indexOf("_component_") != -1 || jarwars[i].delete()) continue;
                this.log("WARNING: failed to delete " + jarwars[i].getPath());
            }
        }
    }

    private void copyRuntime0(File[] runtimes) {
        File rtf = null;
        File destFile = null;
        String rtfName = null;
        boolean overwrite = true;
        try {
            for (int i = 0; i < runtimes.length; ++i) {
                rtf = runtimes[i];
                rtfName = rtf.getName();
                destFile = new File(this.distDir, rtfName);
                this.fileUtils.copyFile(rtf, destFile, null, overwrite);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BuildException("Failed to copy a runtime file.", (Throwable)ex);
        }
    }

    private void copyRuntime() {
        if (this.srcDir.compareTo(this.distDir) == 0) {
            return;
        }
        File[] s1asRuntimeFiles = this.srcDir.listFiles(ArchiveInfo.s1asRuntimeFileFilter);
        if (s1asRuntimeFiles.length == 0) {
            this.log("WARNING: No s1as runtime.xml files in:" + this.srcDir.getPath(), 3);
        } else {
            this.copyRuntime0(s1asRuntimeFiles);
        }
        File[] runtimeFiles = this.srcDir.listFiles(ArchiveInfo.runtimeFileFilter);
        if (runtimeFiles.length != 0) {
            this.copyRuntime0(runtimeFiles);
        }
        if (buildLevel == 2) {
            this.checkRuntimeFileName();
        }
    }

    private void checkRuntimeFileName0(String warName, String extension) {
        String expectedRuntimeFileName = warName.substring(0, warName.indexOf(".war")) + extension;
        File expectedRuntimeFile = new File(this.distDir, expectedRuntimeFileName);
        if (!expectedRuntimeFile.exists()) {
            int x = warName.lastIndexOf("_web");
            String otherName = null;
            if (x == -1) {
                this.log("war name: " + warName + " does not contain _web, skip renaming runtime file.");
                return;
            }
            otherName = warName.substring(0, x) + extension;
            File otherFile = new File(this.distDir, otherName);
            if (!otherFile.renameTo(expectedRuntimeFile)) {
                this.log("Failed to rename " + otherName + " to " + expectedRuntimeFileName, 3);
            }
        }
    }

    private void checkRuntimeFileName() {
        File[] wars = this.distDir.listFiles(ArchiveInfo.warFilter);
        for (int i = 0; i < wars.length; ++i) {
            String warName = wars[i].getName();
            this.checkRuntimeFileName0(warName, ".runtime.xml");
            this.checkRuntimeFileName0(warName, ".sun-web.xml");
        }
    }

    private void ejbJars4Vehicles() {
        String extraJars = "";
        int n = this.nestedTasks.size();
        for (int i = 0; i < n; ++i) {
            String jarName;
            Task task = (Task)this.nestedTasks.get(i);
            String taskName = task.getTaskName();
            if (taskName.equals("ejb-jar")) {
                jarName = ((EJBJar)task).getName();
                extraJars = extraJars + jarName + ".jar, ";
                continue;
            }
            if (!taskName.equals("webwar")) continue;
            jarName = ((WebWar)task).getName();
            extraJars = extraJars + jarName + ".war, ";
        }
        if (extraJars.endsWith(", ")) {
            extraJars = extraJars.substring(0, extraJars.length() - 2);
            this.vehiclesTask.setExtraJars(extraJars);
        }
    }

    public static ClassLoader getDeliverableClassLoader(Project project) {
        if (deliverableClassLoader == null) {
            deliverableClassLoader = new AntClassLoader(project, TSBuildListener.getTsClasspath(project));
        }
        return deliverableClassLoader;
    }

    private void showTasks() {
        this.log("Nested tasks in container:", 3);
        int n = this.nestedTasks.size();
        for (int i = 0; i < n; ++i) {
            Task nestedTask = (Task)this.nestedTasks.get(i);
            this.log(nestedTask.getTaskName(), 3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addTask(Task task) {
        String taskName;
        if (buildLevel == 1) {
            return;
        }
        Task t = task;
        if (task instanceof UnknownElement) {
            task.maybeConfigure();
            t = ((UnknownElement)task).getTask();
        }
        if ((taskName = t.getTaskName()).equals("vehicles")) {
            if (!(t instanceof TSVehicles)) throw new BuildException("task vehicles is not instanceof TSVehicles");
            this.vehiclesTask = (TSVehicles)t;
        } else if (taskName.equals("ejbjar")) {
            throw new BuildException("Use ejb-jar task instead of ejbjar.");
        }
        this.nestedTasks.add(t);
    }

    static {
        builtCommonApps = new ArrayList();
    }
}

