/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Frame;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public class FrameRenderer
extends AbstractRenderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"name", "scrolling"};

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.startElement("frame", component);
        }
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Frame frame = (Frame)component;
        if (!RenderingUtilities.isPortlet(context)) {
            String style;
            String styleClass;
            String url;
            String id = frame.getClientId(context);
            if (id != null) {
                writer.writeAttribute("id", (Object)id, null);
            }
            if ((url = frame.getUrl()) != null) {
                url = context.getApplication().getViewHandler().getResourceURL(context, url);
                RenderingUtilities.renderURLAttribute(context, writer, component, "src", url, null);
            }
            if ((styleClass = frame.getStyleClass()) != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if ((style = frame.getStyle()) != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            FrameRenderer.addStringAttributes(context, component, writer, STRING_ATTRIBUTES);
            boolean border = frame.isFrameBorder();
            if (border) {
                writer.writeAttribute("frameborder", (Object)"1", null);
            } else {
                writer.writeAttribute("frameborder", (Object)"0", null);
            }
            String longdesc = frame.getLongDesc();
            if (longdesc != null) {
                writer.writeAttribute("longdesc", (Object)longdesc, null);
            }
            Integer marginWidth = frame.getMarginWidth();
            if (frame.getMarginWidth() >= 0) {
                writer.writeAttribute("marginwidth", (Object)marginWidth.toString(), null);
            }
            Integer marginHeight = frame.getMarginHeight();
            if (frame.getMarginHeight() >= 0) {
                writer.writeAttribute("marginheight", (Object)marginHeight.toString(), null);
            }
            this.renderResizeAttribute(writer, component);
            String toolTip = frame.getToolTip();
            if (toolTip != null) {
                writer.writeAttribute("title", (Object)toolTip, "toolTip");
            }
        }
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.write(" />");
            writer.write("\n");
        }
    }

    protected void renderResizeAttribute(ResponseWriter writer, UIComponent comp) throws IOException {
        boolean noresize = ((Frame)comp).isNoResize();
        if (noresize) {
            writer.writeAttribute("noresize", (Object)"noresize", null);
        }
    }
}

