/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.security.services.api.common.Attribute;

public class AttributeImpl
implements Attribute {
    private String name;
    private final Set<String> values = new TreeSet<String>();

    protected AttributeImpl() {
    }

    public AttributeImpl(String name) {
        this.name = name;
    }

    public AttributeImpl(String name, String value) {
        this(name);
        this.addValue(value);
    }

    public AttributeImpl(String name, Set<String> values) {
        this(name);
        this.addValues(values);
    }

    public AttributeImpl(String name, String[] values) {
        this(name);
        this.addValues(values);
    }

    @Override
    public int getValueCount() {
        return this.values.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        if (this.getValueCount() == 0) {
            return null;
        }
        Iterator<String> i = this.values.iterator();
        return i.next();
    }

    @Override
    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public String[] getValuesAsArray() {
        return this.values.toArray(new String[0]);
    }

    @Override
    public void addValue(String value) {
        if (value != null && !value.trim().equals("")) {
            this.values.add(value);
        }
    }

    @Override
    public void addValues(Set<String> values) {
        this.addValues(values.toArray(new String[0]));
    }

    @Override
    public void addValues(String[] values) {
        for (String value : values) {
            this.addValue(value);
        }
    }

    @Override
    public void removeValue(String value) {
        this.values.remove(value);
    }

    @Override
    public void removeValues(Set<String> values) {
        this.values.removeAll(values);
    }

    @Override
    public void removeValues(String[] values) {
        this.values.removeAll(Arrays.asList(values));
    }

    @Override
    public void clear() {
        this.values.clear();
    }
}

