/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.search;

import com.sun.faces.component.search.AbstractSearchKeywordResolverImpl;
import jakarta.faces.FacesException;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchKeywordResolverImplId
extends AbstractSearchKeywordResolverImpl {
    private static final Pattern PATTERN = Pattern.compile("id\\(([\\w-]+)\\)");

    @Override
    public void resolve(SearchKeywordContext searchKeywordContext, UIComponent current, String keyword) {
        FacesContext facesContext = searchKeywordContext.getSearchExpressionContext().getFacesContext();
        String id = this.extractId(keyword);
        if (this.isHintSet(searchKeywordContext.getSearchExpressionContext(), SearchExpressionHint.SKIP_VIRTUAL_COMPONENTS)) {
            this.findWithId(facesContext, id, current, searchKeywordContext.getCallback());
        } else {
            current.visitTree(VisitContext.createVisitContext(facesContext, null, searchKeywordContext.getSearchExpressionContext().getVisitHints()), (context, target) -> {
                if (id.equals(target.getId())) {
                    searchKeywordContext.invokeContextCallback(target);
                    if (this.isHintSet(searchKeywordContext.getSearchExpressionContext(), SearchExpressionHint.RESOLVE_SINGLE_COMPONENT)) {
                        return VisitResult.COMPLETE;
                    }
                    return VisitResult.ACCEPT;
                }
                return VisitResult.ACCEPT;
            });
        }
        searchKeywordContext.setKeywordResolved(true);
    }

    @Override
    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        if (keyword.startsWith("id")) {
            try {
                Matcher matcher = PATTERN.matcher(keyword);
                return matcher.matches();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected String extractId(String expression) {
        Matcher matcher = PATTERN.matcher(expression);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new FacesException("Expression does not match following pattern @id(id). Expression: \"" + expression + "\"");
    }

    private void findWithId(FacesContext context, String id, UIComponent base, ContextCallback callback) {
        if (id.equals(base.getId())) {
            callback.invokeContextCallback(context, base);
        }
        if (base.getFacetCount() > 0) {
            for (UIComponent facet : base.getFacets().values()) {
                this.findWithId(context, id, facet, callback);
            }
        }
        if (base.getChildCount() > 0) {
            int childCount = base.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = base.getChildren().get(i);
                this.findWithId(context, id, child, callback);
            }
        }
    }
}

