/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.policies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.emf.ecoretools.diagram.edit.commands.CompartmentChildCreateCommand;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EcoreCreationEditPolicy;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class CompartmentChildCreationEditPolicy
extends EcoreCreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            cc.compose((IUndoableOperation)new CompartmentChildCreateCommand(editingDomain, descriptor, (View)this.getHost().getModel(), this.getFeedbackIndexFor((Request)request)));
        }
        return new ICommandProxy(cc.reduce());
    }

    protected int getFeedbackIndexFor(Request request) {
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isHorizontal());
        Point p = transposer.t(this.getLocationFromRequest(request));
        int rowBottom = Integer.MIN_VALUE;
        int candidate = -1;
        if (transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost())).contains(p)) {
            int i = 0;
            while (i < children.size()) {
                EditPart child = (EditPart)children.get(i);
                Rectangle rect = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)child));
                if (rect.y > rowBottom) {
                    if (p.y <= rowBottom) {
                        if (candidate != -1) break;
                        candidate = i;
                        break;
                    }
                    candidate = -1;
                }
                rowBottom = Math.max(rowBottom, rect.bottom());
                if (candidate == -1 && p.x <= rect.x + rect.width / 2) {
                    candidate = i;
                }
                if (candidate != -1 && p.y <= rowBottom) break;
                ++i;
            }
        }
        return candidate;
    }

    protected boolean isHorizontal() {
        IFigure figure = ((GraphicalEditPart)this.getHost()).getContentPane();
        return ((FlowLayout)figure.getLayoutManager()).isHorizontal();
    }

    private Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }

    private Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }
}

