/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.provisional;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractModelProxy
implements IModelProxy {
    private IPresentationContext fContext;
    private Viewer fViewer;
    private boolean fDisposed = false;
    private ListenerList fListeners = new ListenerList();
    public static boolean DEBUG_DELTAS = false;

    static {
        DEBUG_DELTAS = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/deltas"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getListeners() {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            return this.fListeners.getListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelChangedListener(IModelChangedListener listener) {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            this.fListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelChangedListener(IModelChangedListener listener) {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void fireModelChanged(IModelDelta delta) {
        final IModelDelta root = this.getRootDelta(delta);
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IModelChangedListener listener = (IModelChangedListener)listeners[i];
            ISafeRunnable safeRunnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.modelChanged(root, AbstractModelProxy.this);
                }
            };
            SafeRunner.run((ISafeRunnable)safeRunnable);
            ++i;
        }
    }

    protected IModelDelta getRootDelta(IModelDelta delta) {
        IModelDelta parent = delta.getParentDelta();
        while (parent != null) {
            delta = parent;
            parent = delta.getParentDelta();
        }
        return delta;
    }

    public synchronized void dispose() {
        this.fDisposed = true;
        this.fContext = null;
        this.fViewer = null;
    }

    public void init(IPresentationContext context) {
        this.fContext = context;
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    public void installed(Viewer viewer) {
        this.fViewer = viewer;
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    public synchronized boolean isDisposed() {
        return this.fDisposed;
    }
}

