/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.ui.breakpoints.JavaBreakpointConditionEditor;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.breakpoints.CompositeBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.breakpoints.ExceptionBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.breakpoints.MethodBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.breakpoints.StandardJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.breakpoints.WatchpointEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaBreakpointPage
extends PropertyPage {
    protected JavaElementLabelProvider fJavaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
    protected Button fEnabledButton;
    protected List fErrorMessages = new ArrayList();
    protected String fPrevMessage = null;
    private AbstractJavaBreakpointEditor fEditor;
    public static final String ATTR_DELETE_ON_CANCEL = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".ATTR_DELETE_ON_CANCEL";
    protected static final String EMPTY_STRING = "";
    static /* synthetic */ Class class$0;

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean delOnCancel;
                IJavaBreakpoint breakpoint = JavaBreakpointPage.this.getBreakpoint();
                boolean bl = delOnCancel = breakpoint.getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null;
                if (delOnCancel) {
                    breakpoint.getMarker().setAttribute(ATTR_DELETE_ON_CANCEL, null);
                    breakpoint.setRegistered(true);
                }
                JavaBreakpointPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
            JDIDebugUIPlugin.log(e);
        }
        return super.performOk();
    }

    protected void addErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage((String)this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    protected void doStore() throws CoreException {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        this.storeEnabled(breakpoint);
        if (this.fEditor.isDirty()) {
            this.fEditor.doSave();
        }
    }

    private void storeEnabled(IJavaBreakpoint breakpoint) throws CoreException {
        breakpoint.setEnabled(this.fEnabledButton.getSelection());
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768, (int)0, (int)0);
        this.createLabels(mainComposite);
        this.createLabel(mainComposite, EMPTY_STRING);
        this.createEnabledButton(mainComposite);
        this.createTypeSpecificEditors(mainComposite);
        this.setValid(true);
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getShell().addShellListener(new ShellListener(){

                    public void shellActivated(ShellEvent e) {
                        Shell shell = (Shell)e.getSource();
                        shell.setText(MessageFormat.format((String)PropertyPageMessages.JavaBreakpointPage_10, (Object[])new String[]{JavaBreakpointPage.this.getName((IAdaptable)JavaBreakpointPage.this.getBreakpoint())}));
                        shell.removeShellListener((ShellListener)this);
                    }

                    public void shellClosed(ShellEvent e) {
                    }

                    public void shellDeactivated(ShellEvent e) {
                    }

                    public void shellDeiconified(ShellEvent e) {
                    }

                    public void shellIconified(ShellEvent e) {
                    }
                });
            }
        }
        catch (CoreException coreException) {}
        return mainComposite;
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
            return adapter.getLabel((Object)element);
        }
        return EMPTY_STRING;
    }

    protected void createLabels(Composite parent) {
        Composite labelComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)768, (int)0, (int)0);
        try {
            String typeName = ((IJavaBreakpoint)this.getElement()).getTypeName();
            if (typeName != null) {
                this.createLabel(labelComposite, PropertyPageMessages.JavaBreakpointPage_3);
                Text text = SWTFactory.createText((Composite)labelComposite, (int)8, (int)1, (String)typeName);
                text.setBackground(parent.getBackground());
            }
            this.createTypeSpecificLabels(labelComposite);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    protected void createEnabledButton(Composite parent) {
        this.fEnabledButton = this.createCheckButton(parent, PropertyPageMessages.JavaBreakpointPage_5);
        try {
            this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    protected IJavaBreakpoint getBreakpoint() {
        return (IJavaBreakpoint)this.getElement();
    }

    protected void createTypeSpecificLabels(Composite parent) {
        IJavaBreakpoint jb = this.getBreakpoint();
        if (jb instanceof IJavaLineBreakpoint) {
            IJavaLineBreakpoint breakpoint = (IJavaLineBreakpoint)jb;
            StringBuffer lineNumber = new StringBuffer(4);
            try {
                int lNumber = breakpoint.getLineNumber();
                if (lNumber > 0) {
                    lineNumber.append(lNumber);
                }
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.log(ce);
            }
            if (lineNumber.length() > 0) {
                this.createLabel(parent, PropertyPageMessages.JavaLineBreakpointPage_2);
                Text text = SWTFactory.createText((Composite)parent, (int)8, (int)1, (String)lineNumber.toString());
                text.setBackground(parent.getBackground());
            }
            try {
                IMember member = BreakpointUtils.getMember(breakpoint);
                if (member == null) {
                    return;
                }
                String label = PropertyPageMessages.JavaLineBreakpointPage_3;
                if (breakpoint instanceof IJavaMethodBreakpoint) {
                    label = PropertyPageMessages.JavaLineBreakpointPage_4;
                } else if (breakpoint instanceof IJavaWatchpoint) {
                    label = PropertyPageMessages.JavaLineBreakpointPage_5;
                }
                this.createLabel(parent, label);
                Text text = SWTFactory.createText((Composite)parent, (int)8, (int)1, (String)this.fJavaLabelProvider.getText((Object)member));
                text.setBackground(parent.getBackground());
            }
            catch (CoreException exception) {
                JDIDebugUIPlugin.log(exception);
            }
        }
    }

    protected void createTypeSpecificEditors(Composite parent) {
        try {
            String type = this.getBreakpoint().getMarker().getType();
            if ("org.eclipse.jdt.debug.javaClassPrepareBreakpointMarker".equals(type)) {
                this.setTitle(PropertyPageMessages.JavaBreakpointPage_11);
                this.fEditor = new StandardJavaBreakpointEditor();
            } else if ("org.eclipse.jdt.debug.javaLineBreakpointMarker".equals(type)) {
                this.setTitle(PropertyPageMessages.JavaLineBreakpointPage_18);
                this.fEditor = new CompositeBreakpointEditor(new AbstractJavaBreakpointEditor[]{new StandardJavaBreakpointEditor(), new JavaBreakpointConditionEditor(null)});
            } else if ("org.eclipse.jdt.debug.javaExceptionBreakpointMarker".equals(type)) {
                this.setTitle(PropertyPageMessages.JavaExceptionBreakpointPage_5);
                this.fEditor = new ExceptionBreakpointEditor();
            } else if ("org.eclipse.jdt.debug.javaWatchpointMarker".equals(type)) {
                this.setTitle(PropertyPageMessages.JavaLineBreakpointPage_19);
                this.fEditor = new WatchpointEditor();
            } else if ("org.eclipse.jdt.debug.javaMethodBreakpointMarker".equals(type)) {
                this.setTitle(PropertyPageMessages.JavaLineBreakpointPage_20);
                this.fEditor = new CompositeBreakpointEditor(new AbstractJavaBreakpointEditor[]{new MethodBreakpointEditor(), new JavaBreakpointConditionEditor(null)});
            } else {
                this.fEditor = new StandardJavaBreakpointEditor();
            }
            this.fEditor.createControl(parent);
            this.fEditor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    IStatus status = JavaBreakpointPage.this.fEditor.getStatus();
                    if (status.isOK()) {
                        if (JavaBreakpointPage.this.fPrevMessage != null) {
                            JavaBreakpointPage.this.removeErrorMessage(JavaBreakpointPage.this.fPrevMessage);
                            JavaBreakpointPage.this.fPrevMessage = null;
                        }
                    } else {
                        JavaBreakpointPage.this.fPrevMessage = status.getMessage();
                        JavaBreakpointPage.this.addErrorMessage(JavaBreakpointPage.this.fPrevMessage);
                    }
                }
            });
            this.fEditor.setInput(this.getBreakpoint());
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    protected Text createText(Composite parent, String initialValue) {
        return SWTFactory.createText((Composite)parent, (int)2052, (int)1, (String)initialValue);
    }

    protected Button createCheckButton(Composite parent, String text) {
        return SWTFactory.createCheckButton((Composite)parent, (String)text, null, (boolean)false, (int)1);
    }

    protected Label createLabel(Composite parent, String text) {
        return SWTFactory.createLabel((Composite)parent, (String)text, (int)1);
    }

    protected Button createRadioButton(Composite parent, String text) {
        return SWTFactory.createRadioButton((Composite)parent, (String)text, (int)1);
    }

    public boolean performCancel() {
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getBreakpoint().delete();
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(PropertyPageMessages.JavaBreakpointPage_9, e.getStatus());
        }
        return super.performCancel();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_BREAKPOINT_PROPERTY_PAGE);
    }
}

