/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.debug.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.launching.debug.IAntDebugController;
import org.eclipse.ant.internal.launching.debug.model.AntDebugElement;
import org.eclipse.ant.internal.launching.debug.model.AntLineBreakpoint;
import org.eclipse.ant.internal.launching.debug.model.AntThread;
import org.eclipse.ant.internal.launching.debug.model.DebugModelMessages;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

public class AntDebugTarget
extends AntDebugElement
implements IDebugTarget,
IDebugEventSetListener,
IBreakpointManagerListener {
    private IProcess fProcess;
    private ILaunch fLaunch;
    private String fName;
    private boolean fSuspended = false;
    private boolean fTerminated = false;
    private AntThread fThread;
    private IThread[] fThreads;
    private IAntDebugController fController;
    private List fRunToLineBreakpoints;

    public AntDebugTarget(ILaunch launch, IProcess process, IAntDebugController controller) {
        super(null);
        this.fLaunch = launch;
        this.fProcess = process;
        this.fController = controller;
        this.fThread = new AntThread(this);
        this.fThreads = new IThread[]{this.fThread};
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return !this.fTerminated && this.fThreads.length > 0;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            try {
                this.fName = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", DebugModelMessages.AntDebugTarget_0);
                this.fName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fName);
            }
            catch (CoreException coreException) {
                this.fName = DebugModelMessages.AntDebugTarget_0;
            }
        }
        return this.fName;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals("org.eclipse.ant.ui.debug");
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        this.terminated();
    }

    public boolean canResume() {
        return !this.fTerminated && this.fSuspended;
    }

    public boolean canSuspend() {
        return !this.fTerminated && !this.fSuspended;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        this.fSuspended = false;
        this.fController.resume();
        if (this.fThread.isSuspended()) {
            this.fThread.resumedByTarget();
        }
        this.fireResumeEvent(32);
    }

    public void suspended(int detail) {
        this.fSuspended = true;
        this.fThread.setStepping(false);
        this.fThread.fireSuspendEvent(detail);
    }

    public void suspend() throws DebugException {
        this.fController.suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.fTerminated) {
            this.fController.handleBreakpoint(breakpoint, true);
            if (breakpoint instanceof AntLineBreakpoint && ((AntLineBreakpoint)breakpoint).isRunToLine()) {
                if (this.fRunToLineBreakpoints == null) {
                    this.fRunToLineBreakpoints = new ArrayList();
                }
                this.fRunToLineBreakpoints.add(breakpoint);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.fTerminated) {
            this.fController.handleBreakpoint(breakpoint, false);
            if (this.fRunToLineBreakpoints != null && this.fRunToLineBreakpoints.remove(breakpoint) && this.fRunToLineBreakpoints.isEmpty()) {
                this.fRunToLineBreakpoints = null;
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled() && DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void buildStarted() {
        this.fireCreationEvent();
        this.installDeferredBreakpoints();
        try {
            this.resume();
        }
        catch (DebugException debugException) {}
    }

    private void installDeferredBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        if (!manager.isEnabled()) {
            return;
        }
        IBreakpoint[] breakpoints = manager.getBreakpoints("org.eclipse.ant.ui.debug");
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            try {
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoints[i]);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    public void terminated() {
        if (!this.fTerminated) {
            this.fThreads = new IThread[0];
            this.fTerminated = true;
            this.fSuspended = false;
            this.fController.terminate();
            this.fController = null;
            if (DebugPlugin.getDefault() != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
            }
            if (!this.getProcess().isTerminated()) {
                try {
                    this.fProcess.terminate();
                }
                catch (DebugException debugException) {}
            }
            if (DebugPlugin.getDefault() != null) {
                this.fireTerminateEvent();
            }
        }
    }

    public void stepOver() {
        this.fSuspended = false;
        this.fController.stepOver();
        this.fireResumeEvent(32);
    }

    public void stepInto() {
        this.fSuspended = false;
        this.fController.stepInto();
        this.fireResumeEvent(32);
    }

    public void breakpointHit(String event) {
        ILineBreakpoint lineBreakpoint;
        String[] datum = event.split(",");
        String fileName = datum[1];
        int lineNumber = Integer.parseInt(datum[2]);
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.ant.ui.debug");
        boolean found = false;
        int i = 0;
        while (i < breakpoints.length) {
            lineBreakpoint = (ILineBreakpoint)breakpoints[i];
            if (this.setThreadBreakpoint(lineBreakpoint, lineNumber, fileName)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found && this.fRunToLineBreakpoints != null) {
            Iterator iter = this.fRunToLineBreakpoints.iterator();
            while (iter.hasNext()) {
                lineBreakpoint = (ILineBreakpoint)iter.next();
                if (this.setThreadBreakpoint(lineBreakpoint, lineNumber, fileName)) break;
            }
        }
        this.suspended(16);
    }

    private boolean setThreadBreakpoint(ILineBreakpoint lineBreakpoint, int lineNumber, String fileName) {
        try {
            if (lineBreakpoint.getLineNumber() == lineNumber && fileName.equals(lineBreakpoint.getMarker().getResource().getLocation().toOSString())) {
                this.fThread.setBreakpoints(new IBreakpoint[]{lineBreakpoint});
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void breakpointHit(IBreakpoint breakpoint) {
        this.fThread.setBreakpoints(new IBreakpoint[]{breakpoint});
        this.suspended(16);
    }

    public void getStackFrames() {
        if (this.isSuspended()) {
            this.fController.getStackFrames();
        }
    }

    public void getProperties() {
        if (!this.fTerminated) {
            this.fController.getProperties();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8 && event.getSource().equals(this.fProcess)) {
                this.terminated();
            }
            ++i;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.ant.ui.debug");
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (enabled) {
                this.breakpointAdded(breakpoint);
            } else {
                this.breakpointRemoved(breakpoint, null);
            }
            ++i;
        }
    }

    public IAntDebugController getAntDebugController() {
        return this.fController;
    }
}

