/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextMessages;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ContextData {
    private static final String EMPTY_STRING = "";
    protected static int NUM_OF_COLUMNS = 2;
    protected static int CONTEXT_DATA_KEY_COLUMN = 0;
    protected static int CONTEXT_DATA_VALUE_COLUMN = 1;
    private final TabFolder folder;
    protected TreeViewer dataViewer;
    private TabItem tabData;
    protected Button showFunctionsButton;
    protected Button showCachedButton;
    protected boolean showFunctions;
    protected boolean showCached;
    private FontRegistry registry;
    private Font bold;
    private Font italic;

    public ContextData(TabFolder folder) {
        this.folder = folder;
        this.registry = new FontRegistry();
    }

    public TreeViewer createControls() {
        this.fillFontCache();
        this.tabData = new TabItem(this.folder, 0, 0);
        this.tabData.setText(ContextMessages.dataTab);
        Composite pageData = new Composite((Composite)this.folder, 0);
        this.tabData.setControl((Control)pageData);
        GridLayout rightPaneLayout = new GridLayout();
        rightPaneLayout.marginHeight = 0;
        rightPaneLayout.marginWidth = 0;
        pageData.setLayout((Layout)rightPaneLayout);
        FilteredTree dataTree = new FilteredTree(pageData, 68356, new PatternFilter(), true);
        GridData gridData = new GridData(4, 4, true, true);
        dataTree.setLayoutData((Object)gridData);
        this.dataViewer = dataTree.getViewer();
        ContextDataLabelProvider labelProvider = new ContextDataLabelProvider();
        ContextDataContentProvider contentProvider = new ContextDataContentProvider();
        ContextDataComparator comparator = new ContextDataComparator(labelProvider);
        this.dataViewer.setComparator((ViewerComparator)comparator);
        Tree tree = this.dataViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn keyColumn = new TreeColumn(tree, 16384);
        keyColumn.setText(ContextMessages.keyColumn);
        tree.setSortColumn(keyColumn);
        tree.setSortDirection(comparator.isAscending() ? 128 : 1024);
        keyColumn.addSelectionListener((SelectionListener)new SortColumn(comparator, keyColumn, this.dataViewer, CONTEXT_DATA_KEY_COLUMN));
        TreeColumn dataColumn = new TreeColumn(tree, 16384);
        dataColumn.setText(ContextMessages.valueColumn);
        dataColumn.addSelectionListener((SelectionListener)new SortColumn(comparator, dataColumn, this.dataViewer, CONTEXT_DATA_VALUE_COLUMN));
        this.dataViewer.setContentProvider((IContentProvider)contentProvider);
        this.dataViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        dataTree.getPatternFilter().setIncludeLeadingWildcard(true);
        TreeColumn[] columns = this.dataViewer.getTree().getColumns();
        columns[CONTEXT_DATA_KEY_COLUMN].setWidth(150);
        columns[CONTEXT_DATA_VALUE_COLUMN].setWidth(150);
        this.showFunctionsButton = new Button(pageData, 32);
        this.showFunctionsButton.setFont(this.getBold());
        this.showFunctionsButton.setText(ContextMessages.showFunctions);
        this.showFunctionsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextData.this.showFunctions = ContextData.this.showFunctionsButton.getSelection();
                ContextData.this.dataViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.showFunctionsButton.setSelection(true);
        this.showFunctions = true;
        this.showCachedButton = new Button(pageData, 32);
        this.showCachedButton.setFont(this.getItalic());
        this.showCachedButton.setText(ContextMessages.showCached);
        this.showCachedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextData.this.showCached = ContextData.this.showCachedButton.getSelection();
                ContextData.this.dataViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.showCachedButton.setSelection(true);
        this.showCached = true;
        return this.dataViewer;
    }

    protected void fillFontCache() {
        FontData[] fontData = Display.getCurrent().getSystemFont().getFontData();
        String fontName = fontData[0].getName();
        this.bold = this.registry.getBold(fontName);
        this.italic = this.registry.getItalic(fontName);
    }

    protected Font getBold() {
        return this.bold;
    }

    protected Font getItalic() {
        return this.italic;
    }

    private static class ContextDataComparator
    extends ViewerComparator {
        final ContextDataLabelProvider labelProvider;
        private LinkedList<Integer> sortColumns = new LinkedList();
        private boolean ascending = true;

        public ContextDataComparator(ContextDataLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
            int i = 0;
            while (i < NUM_OF_COLUMNS) {
                this.sortColumns.add(i);
                ++i;
            }
        }

        public final int compare(Viewer viewer, Object a, Object b) {
            int result = 0;
            Iterator iterator = this.sortColumns.iterator();
            while (iterator.hasNext()) {
                int column = (Integer)iterator.next();
                String labelA = this.labelProvider.getColumnText(a, column);
                String labelB = this.labelProvider.getColumnText(b, column);
                if (labelA != null && labelB != null && (result = this.getComparator().compare(labelA, labelB)) != 0) break;
            }
            return this.ascending ? result : -result;
        }

        public int getSortColumn() {
            return this.sortColumns.getFirst();
        }

        public void setSortColumn(int column) {
            if (column == this.getSortColumn()) {
                return;
            }
            this.sortColumns.remove(column);
            this.sortColumns.addFirst(column);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    private class ContextDataContentProvider
    implements ITreeContentProvider {
        private EclipseContext selectedContext;

        public void dispose() {
            this.selectedContext = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.selectedContext = (EclipseContext)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.selectedContext == null) {
                return new Object[0];
            }
            Map localData = this.selectedContext.localData();
            Map localContextFunction = this.selectedContext.localContextFunction();
            Map cachedCachedContextFunctions = this.selectedContext.cachedCachedContextFunctions();
            int size = localData.size() + localContextFunction.size() + cachedCachedContextFunctions.size();
            HashSet<ContextDataElement> result = new HashSet<ContextDataElement>(size);
            for (String key : localData.keySet()) {
                result.add(new ContextDataElement(key, localData.get(key), ContextDataElement.DataType.NORMAL));
            }
            if (ContextData.this.showFunctions) {
                for (String key : localContextFunction.keySet()) {
                    result.add(new ContextDataElement(key, localContextFunction.get(key), ContextDataElement.DataType.CALCULATED));
                }
            }
            if (ContextData.this.showCached) {
                for (String key : cachedCachedContextFunctions.keySet()) {
                    result.add(new ContextDataElement(key, cachedCachedContextFunctions.get(key), ContextDataElement.DataType.CALCULATED_INHERITED));
                }
            }
            return result.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private static class ContextDataElement {
        private String key;
        private Object value;
        private DataType type;

        public ContextDataElement(String key, Object value, DataType type) {
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public DataType getType() {
            return this.type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DataType {
            NORMAL,
            CALCULATED,
            CALCULATED_INHERITED;

        }
    }

    private class ContextDataLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        public String getColumnText(Object obj, int index) {
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof ContextDataElement)) {
                return obj.toString();
            }
            switch (index) {
                case 0: {
                    return ((ContextDataElement)obj).getKey();
                }
                case 1: {
                    Object value = ((ContextDataElement)obj).getValue();
                    if (value == null) {
                        return ContextData.EMPTY_STRING;
                    }
                    return value.toString();
                }
            }
            return obj.toString();
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            ContextDataElement.DataType type = ((ContextDataElement)element).getType();
            switch (type) {
                case NORMAL: {
                    return null;
                }
                case CALCULATED: {
                    return ContextData.this.getBold();
                }
                case CALCULATED_INHERITED: {
                    return ContextData.this.getItalic();
                }
            }
            return null;
        }
    }

    private final class SortColumn
    extends SelectionAdapter {
        private final ContextDataComparator comparator;
        private final TreeColumn treeColumn;
        private final TreeViewer viewer;
        private final int column;

        public SortColumn(ContextDataComparator comparator, TreeColumn treeColumn, TreeViewer viewer, int column) {
            this.comparator = comparator;
            this.treeColumn = treeColumn;
            this.viewer = viewer;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.comparator.getSortColumn() == this.column) {
                this.comparator.setAscending(!this.comparator.isAscending());
                this.viewer.getTree().setSortDirection(this.comparator.isAscending() ? 128 : 1024);
            } else {
                this.viewer.getTree().setSortColumn(this.treeColumn);
                this.comparator.setSortColumn(this.column);
            }
            try {
                this.viewer.getTree().setRedraw(false);
                this.viewer.refresh();
            }
            finally {
                this.viewer.getTree().setRedraw(true);
            }
        }
    }
}

