/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.services.EContextService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextContextService
implements EContextService {
    static final String LOCAL_CONTEXTS = "localContexts";
    private IEclipseContext eclipseContext;
    private ContextManager contextManager;

    public ContextContextService(IEclipseContext context) {
        this.eclipseContext = context;
        this.contextManager = (ContextManager)context.get(ContextManager.class.getName());
    }

    @Override
    public void activateContext(String id) {
        HashSet<String> locals = (HashSet<String>)this.eclipseContext.getLocal(LOCAL_CONTEXTS);
        locals = locals == null ? new HashSet<String>() : new HashSet(locals);
        locals.add(id);
        this.eclipseContext.set(LOCAL_CONTEXTS, locals);
    }

    @Override
    public void deactivateContext(String id) {
        HashSet locals = (HashSet)this.eclipseContext.getLocal(LOCAL_CONTEXTS);
        if (locals != null) {
            locals = new HashSet(locals);
            locals.remove(id);
            this.eclipseContext.set(LOCAL_CONTEXTS, locals);
        }
    }

    @Override
    public Collection<String> getActiveContextIds() {
        Set set = (Set)this.eclipseContext.get("activeContexts");
        if (set != null) {
            this.contextManager.setActiveContextIds(set);
        }
        return set;
    }

    @Override
    public Context getContext(String id) {
        Context ctx = this.contextManager.getContext(id);
        return ctx;
    }
}

