/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractImportPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ImportFromInstallationPage
extends AbstractImportPage
implements ISelectableIUsPage {
    protected IProvisioningAgent otherInstanceAgent = null;
    private File instancePath = null;
    private URI[] metaURIs = null;
    private URI[] artiURIs = null;
    private IProvisioningAgentProvider agentProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ImportFromInstallationPage(ProvisioningUI ui, ProvisioningOperationWizard wizard) {
        super("importfrominstancepage", ui, wizard);
        this.setTitle(Messages.ImportFromInstallationPage_DIALOG_TITLE);
        this.setDescription(Messages.ImportFromInstallationPage_DIALOG_DESCRIPTION);
    }

    protected void createContents(Composite composite) {
        this.createDestinationGroup(composite);
        this.createInstallationTable(composite);
    }

    protected String getDestinationLabel() {
        return Messages.ImportFromInstallationPage_DESTINATION_LABEL;
    }

    protected String getDialogTitle() {
        return Messages.ImportFromInstallationPage_DIALOG_TITLE;
    }

    protected Object getInput() {
        return new IInstallableUnit[0];
    }

    protected String getInvalidDestinationMessage() {
        return Messages.ImportFromInstallationPage_INVALID_DESTINATION;
    }

    protected String getNoOptionsMessage() {
        return Messages.ImportFromInstallationPage_SELECT_COMPONENT;
    }

    protected boolean validateDestinationGroup() {
        return this.validateDestinationGroup((IProgressMonitor)new NullProgressMonitor());
    }

    private IProvisioningAgentProvider getAgentProvider() {
        if (this.agentProvider == null) {
            BundleContext bundleContext = Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.p2.core.IProvisioningAgentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceTracker tracker = new ServiceTracker(bundleContext, (Class)clazz, null);
            tracker.open();
            this.agentProvider = (IProvisioningAgentProvider)tracker.getService();
            tracker.close();
        }
        return this.agentProvider;
    }

    boolean validateDestinationGroup(IProgressMonitor monitor) {
        boolean rt;
        block27: {
            SubMonitor progress;
            block26: {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
                    Callable<Boolean> getSuperValidateDest = new Callable<Boolean>(){
                        Boolean validated;

                        @Override
                        public Boolean call() throws Exception {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    validated = new Boolean(ImportFromInstallationPage.super.validateDestinationGroup());
                                }
                            });
                            return this.validated;
                        }
                    };
                    ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
                    Future<Boolean> getSuperDestTask = executor.submit(getSuperValidateDest);
                    try {
                        try {
                            rt = getSuperDestTask.get();
                            break block26;
                        }
                        catch (Exception exception) {
                            executor.shutdown();
                            return false;
                        }
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                rt = super.validateDestinationGroup();
            }
            if (rt) {
                try {
                    try {
                        String destinate;
                        if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
                            Callable<String> getDestinationValue = new Callable<String>(){
                                String destination;

                                @Override
                                public String call() throws Exception {
                                    if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
                                        Display.getDefault().syncExec(new Runnable(){

                                            public void run() {
                                                destination = ImportFromInstallationPage.this.getDestinationValue();
                                            }
                                        });
                                    } else {
                                        this.destination = ImportFromInstallationPage.this.getDestinationValue();
                                    }
                                    return this.destination;
                                }
                            };
                            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
                            Future<String> getDestTask = executor.submit(getDestinationValue);
                            try {
                                destinate = getDestTask.get();
                            }
                            finally {
                                executor.shutdown();
                            }
                        } else {
                            destinate = this.getDestinationValue();
                        }
                        try {
                            File p2 = new File(destinate, "p2");
                            if (p2.exists()) {
                                boolean createAgent = true;
                                if (this.otherInstanceAgent != null) {
                                    if (!p2.equals(this.instancePath)) {
                                        this.otherInstanceAgent.stop();
                                        this.otherInstanceAgent = null;
                                        this.instancePath = p2;
                                        this.cleanLocalRepository();
                                    } else {
                                        createAgent = false;
                                    }
                                }
                                if (createAgent) {
                                    this.otherInstanceAgent = this.getAgentProvider().createAgent(p2.toURI());
                                }
                                ExtensionLocationArtifactRepositoryFactory factory = new ExtensionLocationArtifactRepositoryFactory();
                                factory.setAgent(agent);
                                IArtifactRepository artiRepo = factory.load(new File(destinate).toURI(), 0, (IProgressMonitor)progress.newChild(50));
                                this.artiURIs = new URI[]{artiRepo.getLocation()};
                                ExtensionLocationMetadataRepositoryFactory metaFatory = new ExtensionLocationMetadataRepositoryFactory();
                                metaFatory.setAgent(agent);
                                IMetadataRepository metaRepo = metaFatory.load(new File(destinate).toURI(), 0, (IProgressMonitor)progress.newChild(50));
                                this.metaURIs = new URI[]{metaRepo.getLocation()};
                                break block27;
                            }
                            throw new FileNotFoundException();
                        }
                        catch (ProvisionException provisionException) {
                            if (this.otherInstanceAgent != null) {
                                IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                                IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
                                IProfile profile = ((IProfileRegistry)this.otherInstanceAgent.getService(IProfileRegistry.SERVICE_NAME)).getProfiles()[0];
                                IAgentLocation location = (IAgentLocation)this.otherInstanceAgent.getService(IAgentLocation.SERVICE_NAME);
                                URI engineDataArea = location.getDataArea("org.eclipse.equinox.p2.engine");
                                progress.setWorkRemaining(50);
                                IMetadataRepository metaRepo = manager.loadRepository(engineDataArea.resolve("profileRegistry/" + profile.getProfileId() + ".profile"), (IProgressMonitor)progress.newChild(25));
                                this.metaURIs = new URI[]{metaRepo.getLocation()};
                                IArtifactRepository artiRepo = artifactManager.loadRepository(new File(destinate).toURI(), (IProgressMonitor)progress.newChild(25));
                                this.artiURIs = new URI[]{artiRepo.getLocation()};
                                break block27;
                            }
                            throw new Exception();
                        }
                    }
                    catch (Exception exception) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                ImportFromInstallationPage.this.setErrorMessage(ImportFromInstallationPage.this.getInvalidDestinationMessage());
                            }
                        });
                        rt = false;
                        if (this.otherInstanceAgent != null) {
                            this.otherInstanceAgent.stop();
                        }
                        this.otherInstanceAgent = null;
                        this.cleanLocalRepository();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        return rt;
    }

    protected void giveFocusToDestination() {
        this.destinationBrowseButton.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell());
        dialog.setText(this.getDialogTitle());
        dialog.setFilterPath(this.getDestinationValue());
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setDestinationValue(selectedFileName);
        }
    }

    protected void handleDestinationChanged(String newDestination) {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    ProfileElement input = null;
                    if (ImportFromInstallationPage.this.validateDestinationGroup(monitor)) {
                        IProfileRegistry registry = (IProfileRegistry)ImportFromInstallationPage.this.otherInstanceAgent.getService(IProfileRegistry.SERVICE_NAME);
                        final IProfile currentProfile = registry.getProfiles()[0];
                        ProfileElement element = new ProfileElement(null, currentProfile.getProfileId()){

                            public IQueryable<?> getQueryable() {
                                return currentProfile;
                            }
                        };
                        element.setQueryable((IQueryable)currentProfile);
                        input = element;
                    }
                    final ProfileElement viewerInput = input;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            (this).ImportFromInstallationPage.this.viewer.setInput(viewerInput);
                            ImportFromInstallationPage.this.updatePageCompletion();
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getLocalizedMessage());
            this.setPageComplete(false);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean validDestination() {
        if (this.destinationNameField == null) {
            return true;
        }
        File file = new File(this.getDestinationValue());
        return file.exists() && file.isDirectory();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ImportFromInstallationLabelProvider();
    }

    public void dispose() {
        super.dispose();
        if (this.otherInstanceAgent != null) {
            this.otherInstanceAgent.stop();
            this.otherInstanceAgent = null;
        }
        if (this.getWizard().performCancel()) {
            this.cleanLocalRepository();
        }
    }

    public void cleanLocalRepository() {
        if (this.metaURIs != null && this.metaURIs.length > 0) {
            IProvisioningAgent agent = this.getProvisioningUI().getSession().getProvisioningAgent();
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            URI[] uRIArray = this.metaURIs;
            int n = this.metaURIs.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                manager.removeRepository(uri);
                ++n2;
            }
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            URI[] uRIArray2 = this.artiURIs;
            int n3 = this.artiURIs.length;
            n = 0;
            while (n < n3) {
                URI uri = uRIArray2[n];
                artifactManager.removeRepository(uri);
                ++n;
            }
        }
    }

    public Object[] getCheckedIUElements() {
        return this.viewer.getCheckedElements();
    }

    public Object[] getSelectedIUElements() {
        return null;
    }

    public void setCheckedElements(Object[] elements) {
        new UnsupportedOperationException();
    }

    public ProvisioningContext getProvisioningContext() {
        ProvisioningContext context = new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent());
        context.setArtifactRepositories(this.artiURIs);
        context.setMetadataRepositories(this.metaURIs);
        return context;
    }

    class ImportFromInstallationLabelProvider
    extends IUDetailsLabelProvider {
        ImportFromInstallationLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = super.getColumnText(element, columnIndex);
            if (columnIndex == 0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, (Class)clazz);
                return ImportFromInstallationPage.this.getIUNameWithDetail(iu);
            }
            return text;
        }

        public Color getForeground(Object element) {
            IInstallableUnit iu;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (ImportFromInstallationPage.this.hasInstalled(iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, (Class)clazz))) {
                return Display.getDefault().getSystemColor(15);
            }
            return super.getForeground(element);
        }
    }
}

