/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.ui.internal.commands.CommandPersistence;

public class CommandToModelProcessor {
    private Map<String, MCategory> categories = new HashMap<String, MCategory>();
    private Map<String, MCommand> commands = new HashMap<String, MCommand>();

    @Execute
    void process(MApplication application) {
        for (MCategory catModel : application.getCategories()) {
            this.categories.put(catModel.getElementId(), catModel);
        }
        for (MCommand cmdModel : application.getCommands()) {
            this.commands.put(cmdModel.getElementId(), cmdModel);
        }
        CommandManager commandManager = new CommandManager();
        CommandPersistence cp = new CommandPersistence(commandManager);
        cp.reRead();
        this.generateCategories(application, commandManager);
        this.generateCommands(application, commandManager);
        cp.dispose();
    }

    private void generateCommands(MApplication application, CommandManager commandManager) {
        Command[] commandArray = commandManager.getDefinedCommands();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command cmd = commandArray[n2];
            if (!this.commands.containsKey(cmd.getId())) {
                try {
                    MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
                    command.setElementId(cmd.getId());
                    command.setCategory(this.categories.get(cmd.getCategory().getId()));
                    command.setCommandName(cmd.getName());
                    command.setDescription(cmd.getDescription());
                    IParameter[] cmdParms = cmd.getParameters();
                    if (cmdParms != null) {
                        IParameter[] iParameterArray = cmdParms;
                        int n3 = cmdParms.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IParameter cmdParm = iParameterArray[n4];
                            MCommandParameter parmModel = CommandsFactoryImpl.eINSTANCE.createCommandParameter();
                            parmModel.setElementId(cmdParm.getId());
                            parmModel.setName(cmdParm.getName());
                            parmModel.setOptional(cmdParm.isOptional());
                            ParameterType parmType = cmd.getParameterType(cmdParm.getId());
                            if (parmType != null) {
                                parmModel.setTypeId(parmType.getId());
                            }
                            command.getParameters().add(parmModel);
                            ++n4;
                        }
                    }
                    application.getCommands().add(command);
                    this.commands.put(command.getElementId(), command);
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void generateCategories(MApplication application, CommandManager commandManager) {
        Category[] categoryArray = commandManager.getDefinedCategories();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Category cat = categoryArray[n2];
            if (!this.categories.containsKey(cat.getId())) {
                try {
                    MCategory catModel = CommandsFactoryImpl.eINSTANCE.createCategory();
                    catModel.setElementId(cat.getId());
                    catModel.setName(cat.getName());
                    catModel.setDescription(cat.getDescription());
                    application.getCategories().add(catModel);
                    this.categories.put(catModel.getElementId(), catModel);
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }
}

