/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.RouteServerEndpoint;

public class DescribeRouteServerEndpointsIterable
implements SdkIterable<DescribeRouteServerEndpointsResponse> {
    private final Ec2Client client;
    private final DescribeRouteServerEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRouteServerEndpointsIterable(Ec2Client client, DescribeRouteServerEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRouteServerEndpointsResponseFetcher();
    }

    public Iterator<DescribeRouteServerEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RouteServerEndpoint> routeServerEndpoints() {
        Function<DescribeRouteServerEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.routeServerEndpoints() != null) {
                return response.routeServerEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRouteServerEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeRouteServerEndpointsResponse> {
        private DescribeRouteServerEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteServerEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRouteServerEndpointsResponse nextPage(DescribeRouteServerEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteServerEndpointsIterable.this.client.describeRouteServerEndpoints(DescribeRouteServerEndpointsIterable.this.firstRequest);
            }
            return DescribeRouteServerEndpointsIterable.this.client.describeRouteServerEndpoints((DescribeRouteServerEndpointsRequest)((Object)DescribeRouteServerEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

