/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.javaagent;

import java.security.Policy;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import org.opensearch.javaagent.StackCallerClassChainExtractor;
import org.opensearch.javaagent.bootstrap.AgentPolicy;

public class RuntimeHaltInterceptor {
    @Advice.OnMethodEnter
    public static void intercept(int code) throws Exception {
        Collection chain;
        Policy policy = AgentPolicy.getPolicy();
        if (policy == null) {
            return;
        }
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Class<?> caller = walker.getCallerClass();
        if (!AgentPolicy.isChainThatCanExit(caller, (Collection)(chain = (Collection)walker.walk(StackCallerClassChainExtractor.INSTANCE)))) {
            throw new SecurityException("The class " + String.valueOf(caller) + " is not allowed to call Runtime::halt(" + code + ")");
        }
    }
}

