/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonHelper;
import org.hibernate.type.descriptor.jdbc.spi.JsonGeneratingVisitor;
import org.hibernate.type.format.StringJsonDocumentWriter;

public class JsonArrayJdbcType
extends ArrayJdbcType {
    public JsonArrayJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public int getDdlTypeCode() {
        return 3001;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3018;
    }

    @Override
    public String toString() {
        return "JsonArrayJdbcType";
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        if (string == null) {
            return null;
        }
        if (((BasicPluralJavaType)((Object)javaType)).getElementJavaType() instanceof UnknownBasicJavaType) {
            return options.getJsonFormatMapper().fromString(string, javaType, options);
        }
        return JsonHelper.arrayFromString(javaType, this.getElementJdbcType(), string, options);
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        JavaType elementJavaType = ((BasicPluralJavaType)((Object)javaType)).getElementJavaType();
        if (elementJavaType instanceof UnknownBasicJavaType) {
            return options.getJsonFormatMapper().toString(value, javaType, options);
        }
        Object[] domainObjects = javaType.unwrap((Object[])value, Object[].class, options);
        StringJsonDocumentWriter writer = new StringJsonDocumentWriter();
        JsonGeneratingVisitor.INSTANCE.visitArray(elementJavaType, this.getElementJdbcType(), domainObjects, options, writer);
        return writer.getJson();
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String json = ((JsonArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(index, json);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String json = ((JsonArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(name, json);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getString(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(name), options);
            }

            private X getObject(String json, WrapperOptions options) throws SQLException {
                return ((JsonArrayJdbcType)this.getJdbcType()).fromString(json, this.getJavaType(), options);
            }
        };
    }
}

