/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.Logger;

public class HBond
extends Bond {
    float energy;
    private static final double QConst = -27888.0;

    public HBond(Atom atom1, Atom atom2, int order, short mad, short colix, float energy) {
        super(atom1, atom2, order, mad, colix);
        this.energy = energy;
        if (Logger.debugging) {
            Logger.debug("HBond energy = " + energy + " #" + this.getIdentity());
        }
    }

    @Override
    public float getEnergy() {
        return this.energy;
    }

    public static final int calcEnergy(double distAH, double distCH, double distCD, double distAD) {
        int energy = (int)Math.round(-27888.0 / distAH - -27888.0 / distAD + -27888.0 / distCD - -27888.0 / distCH);
        return energy;
    }
}

