#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 microlens
version:              0.4.14.0
visibility:           public
id:                   microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
key:                  microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
license:              BSD-3-Clause
maintainer:           Steven Fontanella <steven.fontanella@gmail.com>
author:               Edward Kmett, Artyom Kazak
homepage:             http://github.com/stevenfontanella/microlens
synopsis:             A tiny lens library with no dependencies
description:
    NOTE: If you'\''re writing an app, you probably want <http://hackage.haskell.org/package/microlens-platform microlens-platform> – it has the most features. <http://hackage.haskell.org/package/microlens microlens> is intended more for library writers who want a tiny lens library (after all, lenses are pretty useful for everything, not just for updating records!).

    This library is an extract from <http://hackage.haskell.org/package/lens lens> (with no dependencies). It'\''s not a toy lenses library, unsuitable for “real world”, but merely a small one. It is compatible with lens, and should have same performance. It also has better documentation.

    There'\''s a longer readme <https://github.com/stevenfontanella/microlens#readme on Github>. It has a migration guide for lens users, a description of other packages in the family, a discussion of other lens libraries you could use instead, and so on.

    Here are some usecases for this library:

    * You want to define lenses or traversals in your own library, but don'\''t want to depend on lens. Having lenses available often make working with a library more pleasant.

    * You just want to be able to use lenses to transform data (or even just use @over _1@ to change the first element of a tuple).

    * You are new to lenses and want a small library to play with.

    However, don'\''t use this library if:

    * You need @Iso@s, @Prism@s, indexed traversals, or actually anything else which isn'\''t defined here (though some indexed functions are available elsewhere – containers and vector provide them for their types, and <http://hackage.haskell.org/package/ilist ilist> provides indexed functions for lists).

    * You want a library with a clean, understandable implementation (in which case you'\''re looking for <http://hackage.haskell.org/package/lens-simple lens-simple>).

    As already mentioned, if you'\''re writing an application which uses lenses more extensively, look at <http://hackage.haskell.org/package/microlens-platform microlens-platform> – it combines features of most other microlens packages (<http://hackage.haskell.org/package/microlens-mtl microlens-mtl>, <http://hackage.haskell.org/package/microlens-th microlens-th>, <http://hackage.haskell.org/package/microlens-ghc microlens-ghc>).

    If you want to export getters or folds and don'\''t mind the <http://hackage.haskell.org/package/contravariant contravariant> dependency, please consider using <http://hackage.haskell.org/package/microlens-contra microlens-contra>.

    If you haven'\''t ever used lenses before, read <http://hackage.haskell.org/package/lens-tutorial/docs/Control-Lens-Tutorial.html this tutorial>. (It'\''s for lens, but it applies to microlens just as well.)

    Note that microlens has no dependencies starting from GHC 7.10 (base-4.8). Prior to that, it depends on transformers-0.2 or above.

category:             Data, Lenses
abi:                  2fb9f30cccd4ac8dac62115a57474cbe
exposed:              True
exposed-modules:
    Lens.Micro Lens.Micro.Extras Lens.Micro.Internal Lens.Micro.Type

import-dirs:          /usr/lib/ghc-9.6.6/site-local/microlens-0.4.14.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/microlens-0.4.14.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/microlens-0.4.14.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-microlens
hs-libraries:         HSmicrolens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
depends:              base-4.18.2.1
haddock-interfaces:   /usr/share/doc/haskell-microlens/html/microlens.haddock
haddock-html:         /usr/share/doc/haskell-microlens/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

