#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017-2025 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
# ----------------------------------------------------------------------------
#

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "community",
}

DOCUMENTATION = r"""
---
author:
  - Google Inc. (@googlecloudplatform)
description:
  - A database user in an AlloyDB cluster.
extends_documentation_fragment:
  - google.cloud.gcp
module: gcp_alloydb_user
notes:
  - 'API Reference: U(https://cloud.google.com/alloydb/docs/reference/rest/v1/projects.locations.clusters.users/create)'
  - 'AlloyDB Guide: U(https://cloud.google.com/alloydb/docs/)'
options:
  cluster:
    description:
      - Identifies the alloydb cluster.
      - Must be in the format 'projects/{project}/locations/{location}/clusters/{cluster_id}'.
      - This field is a reference to a Cluster resource in GCP.
      - 'It can be specified in two ways: First, you can place a dictionary with key ''name'' matching your resource.'
      - 'Alternatively, you can add `register: name-of-resource` to a Cluster task and then set this field to `{{ name-of-resource }}`.'
    required: true
    type: dict
  database_roles:
    description:
      - List of database roles this database user has.
    elements: str
    type: list
  password:
    description:
      - Password for this database user.
    type: str
  state:
    choices:
      - present
      - absent
    default: present
    description:
      - Whether the resource should exist in GCP.
    type: str
  user_id:
    description:
      - The database role name of the user.
    required: true
    type: str
  user_type:
    choices:
      - ALLOYDB_BUILT_IN
      - ALLOYDB_IAM_USER
    description:
      - The type of this user.
    required: true
    type: str
requirements:
  - python >= 3.8
  - requests >= 2.18.4
  - google-auth >= 2.25.1
short_description: Creates a GCP Alloydb.User resource
"""

EXAMPLES = r"""
- name: Create user for cluster
  google.cloud.gcp_alloydb_user:
    user_id: superuser
    state: present
    user_type: ALLOYDB_BUILT_IN
    password: Test123Test
    database_roles:
      - alloydbsuperuser
    cluster:
      name: projects/my-project/locations/us-central1/clusters/my-cluster
"""

RETURN = r"""
changed:
  description: Whether the resource was changed.
  returned: always
  type: bool
name:
  description:
    - Name of the resource in the form of projects/{project}/locations/{location}/clusters/{cluster}/users/{user}.
  returned: success
  type: str
state:
  description: The current state of the resource.
  returned: always
  type: str
"""

################################################################################
# Imports
################################################################################

from ansible_collections.google.cloud.plugins.module_utils import gcp_utils as gcp

# BEGIN Custom imports
# noop
# END Custom imports


def build_link(module, uri):
    params = module.params.copy()
    params["cluster"] = gcp.replace_resource_dict(module.params["cluster"], "name")

    return "https://alloydb.googleapis.com/v1/" + uri.format(**params)


class Alloydb(gcp.Resource):
    def _request(self):
        return {
            "databaseRoles": [str(item) for item in (self.request.get("database_roles") or [])],
            "password": self.request.get("password"),
            "userType": self.request.get("user_type"),
        }

    def _response(self):
        return {
            "databaseRoles": [str(item) for item in (self.response.get("databaseRoles") or [])],
            "name": self.response.get("name"),
            "password": self.response.get("password"),
            "userType": self.response.get("userType"),
        }


################################################################################
# Main
################################################################################


def main():
    """Main function"""

    module = gcp.Module(
        argument_spec=dict(
            state=dict(
                type="str",
                default="present",
                choices=["present", "absent"],
            ),
            cluster=dict(
                type="dict",
                required=True,
            ),
            database_roles=dict(
                type="list",
                elements="str",
            ),
            password=dict(
                type="str",
                no_log=True,
            ),
            user_id=dict(
                type="str",
                required=True,
            ),
            user_type=dict(
                type="str",
                required=True,
                choices=["ALLOYDB_BUILT_IN", "ALLOYDB_IAM_USER"],
            ),
        )
    )

    if not module.params["scopes"]:
        module.params["scopes"] = ["https://www.googleapis.com/auth/cloud-platform"]

    state = module.params["state"]
    changed = False

    op_configs = gcp.ResourceOpConfigs(
        {
            "create": gcp.ResourceOpConfig(
                **{"uri": "{cluster}/users?userId={user_id}", "async_uri": "", "verb": "POST", "timeout_minutes": 20}
            ),
            "delete": gcp.ResourceOpConfig(
                **{"uri": "{cluster}/users/{user_id}", "async_uri": "", "verb": "DELETE", "timeout_minutes": 20}
            ),
            "read": gcp.ResourceOpConfig(
                **{"uri": "{cluster}/users/{user_id}", "async_uri": "", "verb": "GET", "timeout_minutes": 0}
            ),
            "update": gcp.ResourceOpConfig(
                **{"uri": "{cluster}/users?userId={user_id}", "async_uri": "", "verb": "POST", "timeout_minutes": 20}
            ),
        }
    )

    params = gcp.remove_nones_from_dict(module.params)
    resource = Alloydb(params, module=module, product="Alloydb", kind="alloydb#user")
    existing_obj = resource.get(build_link(module, op_configs.read.uri), allow_not_found=True)

    if existing_obj is None:
        if state == "present":
            is_async = op_configs.create.async_uri != ""
            create_link = build_link(module, op_configs.create.uri)
            create_retries = op_configs.create.timeout
            create_func = getattr(resource, op_configs.create.verb)
            async_create_func = getattr(resource, op_configs.create.verb + "_async")
            async_create_link = build_link(module, "") + op_configs.create.async_uri
            # --------- BEGIN custom pre-create code ---------
            # --------- END custom pre-create code ---------
            try:
                if is_async:
                    new_obj = async_create_func(create_link, async_link=async_create_link, retries=create_retries)
                else:
                    new_obj = create_func(create_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            pass  # nothing to do
    else:
        if state == "absent":
            is_async = op_configs.delete.async_uri != ""
            delete_link = build_link(module, op_configs.delete.uri)
            delete_retries = op_configs.delete.timeout
            delete_func = getattr(resource, op_configs.delete.verb)
            async_delete_func = getattr(resource, op_configs.delete.verb + "_async")
            async_delete_link = build_link(module, "") + op_configs.delete.async_uri
            # --------- BEGIN custom pre-delete code ---------
            # --------- END custom pre-delete code ---------
            try:
                if is_async:
                    new_obj = async_delete_func(delete_link, async_link=async_delete_link, retries=delete_retries)
                else:
                    new_obj = delete_func(delete_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            if resource.diff(existing_obj):
                is_async = op_configs.update.async_uri != ""
                update_link = build_link(module, op_configs.update.uri)
                update_retries = op_configs.update.timeout
                update_func = getattr(resource, op_configs.update.verb)
                async_update_func = getattr(resource, op_configs.update.verb + "_async")
                async_update_link = build_link(module, "") + op_configs.update.async_uri
                # --------- BEGIN custom pre-update code ---------
                # --------- END custom pre-update code ---------
                try:
                    if is_async:
                        new_obj = async_update_func(update_link, async_link=async_update_link, retries=update_retries)
                    else:
                        new_obj = update_func(update_link)
                except Exception as e:
                    module.fail_json(msg=str(e))
                changed = resource.diff(new_obj)

    new_obj = resource.get(build_link(module, op_configs.read.uri), allow_not_found=True)
    new_obj = resource.from_response(new_obj or {})

    new_obj.update({"changed": changed})
    module.exit_json(**new_obj)


if __name__ == "__main__":
    main()
