/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.json.StringOrArrayDeserializer;
import org.keycloak.json.StringOrArraySerializer;
import org.keycloak.representations.AddressClaimSet;
import org.keycloak.util.JsonSerialization;

public class UserInfo {
    @JsonProperty(value="iss")
    protected String issuer;
    @JsonProperty(value="aud")
    @JsonSerialize(using=StringOrArraySerializer.class)
    @JsonDeserialize(using=StringOrArrayDeserializer.class)
    protected String[] audience;
    @JsonProperty(value="sub")
    protected String sub;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="given_name")
    protected String givenName;
    @JsonProperty(value="family_name")
    protected String familyName;
    @JsonProperty(value="middle_name")
    protected String middleName;
    @JsonProperty(value="nickname")
    protected String nickName;
    @JsonProperty(value="preferred_username")
    protected String preferredUsername;
    @JsonProperty(value="profile")
    protected String profile;
    @JsonProperty(value="picture")
    protected String picture;
    @JsonProperty(value="website")
    protected String website;
    @JsonProperty(value="email")
    protected String email;
    @JsonProperty(value="email_verified")
    protected Boolean emailVerified;
    @JsonProperty(value="gender")
    protected String gender;
    @JsonProperty(value="birthdate")
    protected String birthdate;
    @JsonProperty(value="zoneinfo")
    protected String zoneinfo;
    @JsonProperty(value="locale")
    protected String locale;
    @JsonProperty(value="phone_number")
    protected String phoneNumber;
    @JsonProperty(value="phone_number_verified")
    protected Boolean phoneNumberVerified;
    @JsonProperty(value="updated_at")
    protected Long updatedAt;
    @JsonProperty(value="claims_locales")
    protected String claimsLocales;
    protected Map<String, Object> otherClaims = new HashMap<String, Object>();

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @JsonIgnore
    public String[] getAudience() {
        return this.audience;
    }

    public boolean hasAudience(String audience) {
        for (String a : this.audience) {
            if (!a.equals(audience)) continue;
            return true;
        }
        return false;
    }

    public void setAudience(String ... audience) {
        this.audience = audience;
    }

    public String getSubject() {
        return this.sub;
    }

    public void setSubject(String subject) {
        this.sub = subject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public String getZoneinfo() {
        return this.zoneinfo;
    }

    public void setZoneinfo(String zoneinfo) {
        this.zoneinfo = zoneinfo;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Boolean getPhoneNumberVerified() {
        return this.phoneNumberVerified;
    }

    public void setPhoneNumberVerified(Boolean phoneNumberVerified) {
        this.phoneNumberVerified = phoneNumberVerified;
    }

    @JsonIgnore
    public Map<String, Object> getAddressClaimsMap() {
        Object value = this.getOtherClaims().get("address");
        return value instanceof Map ? (Map)value : null;
    }

    @JsonIgnore
    public AddressClaimSet getAddress() {
        Object value = this.getOtherClaims().get("address");
        if (value == null) {
            return null;
        }
        return (AddressClaimSet)JsonSerialization.mapper.convertValue(value, AddressClaimSet.class);
    }

    @JsonIgnore
    public void setAddress(AddressClaimSet address) {
        this.getOtherClaims().put("address", JsonSerialization.mapper.convertValue((Object)address, Map.class));
    }

    @JsonIgnore
    public void setAddress(Map<String, Object> address) {
        this.getOtherClaims().put("address", address);
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimsLocales(String claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    @JsonAnySetter
    public void setOtherClaims(String name, Object value) {
        this.otherClaims.put(name, value);
    }
}

