/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.coordinator.listener.ReaperMonitor;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElementManager;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperThread;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperWorkerThread;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionReaper {
    public static final String NORMAL = "NORMAL";
    public static final String DYNAMIC = "DYNAMIC";
    public static final String PERIODIC = "PERIODIC";
    public static final long defaultCheckPeriod = 120000L;
    public static final long defaultCancelWaitPeriod = 500L;
    public static final long defaultCancelFailWaitPeriod = 500L;
    public static final long defaultUntracedPeriod = 180000L;
    public static final long defaultTracePeriod = 30000L;
    public static final int defaultZombieMax = 8;
    private final ReaperElementManager _reaperElements = new ReaperElementManager();
    private final ConcurrentMap<Object, ReaperElement> _timeouts = new ConcurrentHashMap<Object, ReaperElement>();
    private final List<ReaperElement> _workQueue = new LinkedList<ReaperElement>();
    private final Vector<ReaperMonitor> _listeners = new Vector();
    private long _checkPeriod = 0L;
    private final AtomicLong nextDynamicCheckTime = new AtomicLong(Long.MAX_VALUE);
    private long _cancelWaitPeriod = 0L;
    private long _cancelFailWaitPeriod = 0L;
    private int _zombieMax = 0;
    private long _traceGracePeriod;
    private long _traceInterval;
    private static volatile TransactionReaper _theReaper = null;
    private static ReaperThread _reaperThread = null;
    private static ReaperWorkerThread _reaperWorkerThread = null;
    private static boolean _dynamic = true;
    private static AtomicLong _lifetime = new AtomicLong(0L);
    private static int _zombieCount = 0;
    private boolean _inShutdown = false;

    private TransactionReaper(long checkPeriod) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TransactionReaper::TransactionReaper ( " + checkPeriod + " )"));
        }
        this._checkPeriod = checkPeriod;
    }

    public final long checkingPeriod() {
        long waitTime;
        if (_dynamic) {
            return this.nextDynamicCheckTime.get() - System.currentTimeMillis();
        }
        ReaperElement head = this._reaperElements.getFirst();
        if (head != null && head._status != 0 && (waitTime = head.getNextCheckAbsoluteMillis() - System.currentTimeMillis()) < this._checkPeriod) {
            return waitTime;
        }
        return this._checkPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void check() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"TransactionReaper::check ()");
        }
        while (true) {
            ReaperElement reaperElement;
            long now;
            Object object = this;
            synchronized (object) {
                now = System.currentTimeMillis();
                long next = this.nextDynamicCheckTime.get();
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("TransactionReaper::check comparing now=" + now + " to next=" + next));
                }
                if (now < next) {
                    break;
                }
                reaperElement = this._reaperElements.getFirst();
                if (reaperElement == null) {
                    this.nextDynamicCheckTime.set(Long.MAX_VALUE);
                    return;
                }
                long nextCheck = reaperElement.getNextCheckAbsoluteMillis();
                if (nextCheck > now) {
                    this.nextDynamicCheckTime.set(nextCheck);
                    return;
                }
            }
            if (reaperElement._status != 0 || reaperElement.getNextCheckAbsoluteMillis() >= reaperElement.getTransactionTimeoutAbsoluteMillis()) {
                tsLogger.i18NLogger.warn_coordinator_TransactionReaper_18(reaperElement._control.get_uid(), reaperElement.statusName());
            }
            object = reaperElement;
            synchronized (object) {
                switch (reaperElement._status) {
                    case 0: 
                    case 7: {
                        if (reaperElement.getNextCheckAbsoluteMillis() < reaperElement.getTransactionTimeoutAbsoluteMillis()) {
                            if (tsLogger.logger.isTraceEnabled()) {
                                tsLogger.logger.trace((Object)("Reaper scheduling TX for stackTrace " + String.valueOf(reaperElement._control.get_uid())));
                            }
                            reaperElement._status = 7;
                            now = System.currentTimeMillis();
                            long remaining = reaperElement.getTransactionTimeoutAbsoluteMillis() - now;
                            if (remaining > this._traceInterval) {
                                this.reinsertElement(reaperElement, this._traceInterval);
                            } else {
                                this.reinsertElement(reaperElement, remaining);
                            }
                        } else {
                            if (tsLogger.logger.isTraceEnabled()) {
                                tsLogger.logger.trace((Object)("Reaper scheduling TX for cancellation " + String.valueOf(reaperElement._control.get_uid())));
                            }
                            reaperElement._status = 1;
                            this.reinsertElement(reaperElement, this._cancelWaitPeriod);
                        }
                        List<ReaperElement> now2 = this._workQueue;
                        synchronized (now2) {
                            this._workQueue.add(reaperElement);
                            this._workQueue.notifyAll();
                            break;
                        }
                    }
                    case 1: {
                        this.reinsertElement(reaperElement, this._cancelWaitPeriod);
                        if (!tsLogger.logger.isTraceEnabled()) break;
                        tsLogger.logger.trace((Object)("Reaper deferring interrupt for TX scheduled for cancel " + String.valueOf(reaperElement._control.get_uid())));
                        break;
                    }
                    case 2: {
                        StringBuilder sb = new StringBuilder();
                        for (StackTraceElement element : reaperElement._worker.getStackTrace()) {
                            sb.append(element.toString());
                            sb.append("\n");
                        }
                        tsLogger.i18NLogger.wedged_reaperelement(sb.toString());
                        reaperElement._status = 3;
                        reaperElement._worker.interrupt();
                        this.reinsertElement(reaperElement, this._cancelFailWaitPeriod);
                        if (!tsLogger.logger.isTraceEnabled()) break;
                        tsLogger.logger.trace((Object)("TransactionReaper::check interrupting cancel in progress for " + String.valueOf(reaperElement._control.get_uid())));
                        break;
                    }
                    case 3: {
                        reaperElement._status = 6;
                        TransactionReaper sb = this;
                        synchronized (sb) {
                            ++_zombieCount;
                            if (tsLogger.logger.isTraceEnabled()) {
                                tsLogger.logger.trace((Object)("Reaper " + String.valueOf(Thread.currentThread()) + " got a zombie " + String.valueOf(reaperElement._worker) + " (zombie count now " + _zombieCount + ") cancelling " + String.valueOf(reaperElement._control.get_uid())));
                            }
                            if (_zombieCount == this._zombieMax) {
                                tsLogger.i18NLogger.error_coordinator_TransactionReaper_5(Integer.toString(_zombieCount));
                            }
                        }
                        _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
                        _reaperWorkerThread.setDaemon(true);
                        _reaperWorkerThread.start();
                        tsLogger.i18NLogger.warn_coordinator_TransactionReaper_6(reaperElement._worker.toString(), reaperElement._control.get_uid());
                        this.removeElementReaper(reaperElement);
                        try {
                            if (reaperElement._control.preventCommit()) {
                                tsLogger.i18NLogger.warn_coordinator_TransactionReaper_10(reaperElement._control.get_uid());
                                this.notifyListeners(reaperElement._control, false);
                                break;
                            }
                            tsLogger.i18NLogger.warn_coordinator_TransactionReaper_11(reaperElement._control.get_uid());
                        }
                        catch (Exception e1) {
                            tsLogger.i18NLogger.warn_coordinator_TransactionReaper_12(reaperElement._control.get_uid(), e1);
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.removeElementReaper(reaperElement);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinsertElement(ReaperElement e, long delay) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            long newWakeup = this._reaperElements.reorder(e, delay);
            this.nextDynamicCheckTime.set(newWakeup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForWork() {
        List<ReaperElement> list2 = this._workQueue;
        synchronized (list2) {
            try {
                while (this._workQueue.isEmpty()) {
                    this._workQueue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWork() {
        while (true) {
            ReaperElement e;
            Object object = this._workQueue;
            synchronized (object) {
                try {
                    e = this._workQueue.remove(0);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    break;
                }
            }
            if (e._status == 7) {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("Reaper Worker " + String.valueOf(Thread.currentThread()) + " calling recordStackTraces for " + String.valueOf(e._control.get_uid())));
                }
                object = e;
                synchronized (object) {
                    e._control.recordStackTraces();
                    e._status = 0;
                }
                return;
            }
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("Reaper Worker " + String.valueOf(Thread.currentThread()) + " attempting to cancel " + String.valueOf(e._control.get_uid())));
            }
            boolean cancelled = false;
            Exception exception = null;
            ReaperElement reaperElement = e;
            synchronized (reaperElement) {
                e._worker = Thread.currentThread();
                e._status = 2;
                e.notifyAll();
            }
            try {
                if (e._control.running()) {
                    e._control.outputCapturedStackTraces();
                    if (e._control.cancel() == 4) {
                        cancelled = true;
                        if (TxStats.enabled()) {
                            TxStats.getInstance().incrementTimeouts();
                        }
                        this.notifyListeners(e._control, true);
                    }
                }
            }
            catch (Exception e1) {
                exception = e1;
            }
            ReaperElement e1 = e;
            synchronized (e1) {
                if (e._status == 6) {
                    ReaperWorkerThread worker = (ReaperWorkerThread)Thread.currentThread();
                    worker.shutdown();
                    TransactionReaper transactionReaper = this;
                    synchronized (transactionReaper) {
                    }
                    tsLogger.i18NLogger.warn_coordinator_TransactionReaper_13(Thread.currentThread().toString(), e._control.get_uid(), Integer.toString(--_zombieCount));
                    break;
                }
                if (cancelled && e._status == 3) {
                    cancelled = false;
                    e._status = 4;
                    e.notifyAll();
                } else {
                    e._status = cancelled ? 5 : 4;
                    e.notifyAll();
                }
            }
            if (cancelled) {
                tsLogger.i18NLogger.warn_coordinator_TransactionReaper_7(Thread.currentThread().toString(), e._control.get_uid());
            } else if (e._control.running()) {
                if (exception != null) {
                    tsLogger.i18NLogger.warn_coordinator_TransactionReaper_9(Thread.currentThread().toString(), e._control.get_uid(), exception);
                } else {
                    tsLogger.i18NLogger.warn_coordinator_TransactionReaper_8(Thread.currentThread().toString(), e._control.get_uid());
                }
                try {
                    if (e._control.preventCommit()) {
                        tsLogger.i18NLogger.warn_coordinator_TransactionReaper_14(Thread.currentThread().toString(), e._control.get_uid());
                        this.notifyListeners(e._control, false);
                    } else {
                        tsLogger.i18NLogger.warn_coordinator_TransactionReaper_15(Thread.currentThread().toString(), e._control.get_uid());
                    }
                }
                catch (Exception e12) {
                    tsLogger.i18NLogger.warn_coordinator_TransactionReaper_16(Thread.currentThread().toString(), e._control.get_uid(), e12);
                }
            }
            this.removeElementReaper(e);
        }
    }

    public final long numberOfTransactions() {
        return this._reaperElements.size();
    }

    public final long numberOfTimeouts() {
        return this._timeouts.size();
    }

    public final void addListener(ReaperMonitor listener) {
        this._listeners.add(listener);
    }

    public final boolean removeListener(ReaperMonitor listener) {
        return this._listeners.remove(listener);
    }

    public final void insert(Reapable control, int timeout) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TransactionReaper::insert ( " + String.valueOf(control) + ", " + timeout + " )"));
        }
        if (timeout == 0) {
            return;
        }
        ReaperElement reaperElement = new ReaperElement(control, timeout, this._traceGracePeriod);
        _lifetime.addAndGet(timeout);
        if (this._timeouts.putIfAbsent(reaperElement._control, reaperElement) != null) {
            throw new IllegalStateException(tsLogger.i18NLogger.get_coordinator_TransactionReaper_1());
        }
        this._reaperElements.add(reaperElement);
        if (reaperElement.getNextCheckAbsoluteMillis() < this.nextDynamicCheckTime.get()) {
            this.updateCheckTimeForEarlierInsert(reaperElement.getNextCheckAbsoluteMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckTimeForEarlierInsert(long newCheckTime) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            long oldCheckTime = this.nextDynamicCheckTime.get();
            while (newCheckTime < oldCheckTime) {
                if (this.nextDynamicCheckTime.compareAndSet(oldCheckTime, newCheckTime)) {
                    this.notifyAll();
                    continue;
                }
                oldCheckTime = this.nextDynamicCheckTime.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Object control) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TransactionReaper::remove ( " + String.valueOf(control) + " )"));
        }
        if (control == null) {
            return;
        }
        ReaperElement key = (ReaperElement)this._timeouts.get(control);
        if (key == null) {
            return;
        }
        ReaperElement reaperElement = key;
        synchronized (reaperElement) {
            if (key._status != 0) {
                return;
            }
            this.removeElementClient(key);
        }
    }

    public final long getRemainingTimeoutMills(Object control) {
        if (this._timeouts.isEmpty() || control == null) {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("TransactionReaper::getRemainingTimeout for " + String.valueOf(control) + " returning 0"));
            }
            return 0L;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        long timeout = 0L;
        timeout = reaperElement == null ? 0L : reaperElement.getTransactionTimeoutAbsoluteMillis() - System.currentTimeMillis();
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("TransactionReaper::getRemainingTimeoutMillis for " + String.valueOf(control) + " returning " + timeout));
        }
        return timeout;
    }

    public final int getTimeout(Object control) {
        if (this._timeouts.isEmpty() || control == null) {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("TransactionReaper::getTimeout for " + String.valueOf(control) + " returning 0"));
            }
            return 0;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        int timeout = reaperElement == null ? 0 : reaperElement._timeout;
        tsLogger.logger.trace((Object)("TransactionReaper::getTimeout for " + String.valueOf(control) + " returning " + timeout));
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdown(boolean waitForTransactions) {
        Object object = this;
        synchronized (object) {
            this._inShutdown = true;
            if (!waitForTransactions) {
                this._reaperElements.setAllTimeoutsToZero();
                this.nextDynamicCheckTime.set(0L);
                this.notifyAll();
            }
            this.waitForAllTxnsToTerminate();
            _reaperThread.shutdown();
            this.notifyAll();
        }
        try {
            _reaperThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _reaperThread = null;
        object = this._workQueue;
        synchronized (object) {
            _reaperWorkerThread.shutdown();
            this._workQueue.notifyAll();
            _reaperWorkerThread.interrupt();
        }
        try {
            _reaperWorkerThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _reaperWorkerThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllTxnsToTerminate() {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            while (!this._reaperElements.isEmpty()) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeElementClient(ReaperElement reaperElement) {
        this._reaperElements.remove(reaperElement);
        this._timeouts.remove(reaperElement._control);
        if (this._inShutdown) {
            TransactionReaper transactionReaper = this;
            synchronized (transactionReaper) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeElementReaper(ReaperElement reaperElement) {
        this._reaperElements.remove(reaperElement);
        this._timeouts.remove(reaperElement._control);
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            ReaperElement first = this._reaperElements.getFirst();
            if (first != null) {
                this.nextDynamicCheckTime.set(first.getNextCheckAbsoluteMillis());
            } else {
                this.nextDynamicCheckTime.set(Long.MAX_VALUE);
                if (this._inShutdown) {
                    this.notifyAll();
                }
            }
        }
    }

    private final void notifyListeners(Reapable element, boolean rollback) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            try {
                if (rollback) {
                    this._listeners.get(i).rolledBack(element.get_uid());
                    continue;
                }
                this._listeners.get(i).markedRollbackOnly(element.get_uid());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static synchronized void instantiate() {
        if (_theReaper == null) {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)"TransactionReaper::instantiate()");
            }
            _dynamic = true;
            String mode = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperMode();
            if (mode.compareTo(PERIODIC) == 0) {
                _dynamic = false;
            }
            if (mode.compareTo(NORMAL) == 0) {
                _dynamic = false;
                tsLogger.i18NLogger.warn_coordinator_TransactionReaper_19();
            }
            long checkPeriod = Long.MAX_VALUE;
            if (!_dynamic) {
                checkPeriod = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperTimeout();
            }
            _theReaper = new TransactionReaper(checkPeriod);
            TransactionReaper._theReaper._cancelWaitPeriod = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperCancelWaitPeriod();
            if (TransactionReaper._theReaper._cancelWaitPeriod < 10L) {
                TransactionReaper._theReaper._cancelWaitPeriod = 10L;
            }
            TransactionReaper._theReaper._cancelFailWaitPeriod = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperCancelFailWaitPeriod();
            if (TransactionReaper._theReaper._cancelFailWaitPeriod < 10L) {
                TransactionReaper._theReaper._cancelFailWaitPeriod = 10L;
            }
            TransactionReaper._theReaper._zombieMax = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperZombieMax();
            if (TransactionReaper._theReaper._zombieMax <= 0) {
                TransactionReaper._theReaper._zombieMax = 1;
            }
            TransactionReaper._theReaper._traceGracePeriod = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperTraceGracePeriod();
            TransactionReaper._theReaper._traceInterval = arjPropertyManager.getCoordinatorEnvironmentBean().getTxReaperTraceInterval();
            _reaperThread = new ReaperThread(_theReaper);
            _reaperThread.setDaemon(true);
            _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
            _reaperWorkerThread.setDaemon(true);
            _reaperThread.start();
            _reaperWorkerThread.start();
        }
    }

    public static TransactionReaper transactionReaper() {
        if (_theReaper == null) {
            TransactionReaper.instantiate();
        }
        return _theReaper;
    }

    public static synchronized void terminate(boolean waitForTransactions) {
        if (_theReaper != null) {
            _theReaper.shutdown(waitForTransactions);
            _theReaper = null;
        }
    }

    public static boolean isDynamic() {
        return _dynamic;
    }

    public static synchronized long transactionLifetime() {
        return _lifetime.get();
    }

    static final synchronized void reset() {
        _theReaper = null;
    }
}

