/*
   igraph library.
   Copyright (C) 2011-2025  The igraph development team <igraph@igraph.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

#ifndef IGRAPH_THREADING_H
#define IGRAPH_THREADING_H

#include "igraph_decls.h"

IGRAPH_BEGIN_C_DECLS

/**
 * \define IGRAPH_THREAD_SAFE
 *
 * Specifies whether igraph was built in thread-safe mode.
 *
 * This macro is defined to 1 if the current build of the igraph library is
 * built in thread-safe mode, and 0 if it is not. A thread-safe igraph library
 * attempts to use thread-local data structures instead of global ones, but
 * note that this is not (and can not) be guaranteed for third-party libraries
 * that igraph links to.
 */

#define IGRAPH_THREAD_SAFE 1

IGRAPH_END_C_DECLS

#endif
