/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class ChildVerticalGapControlGroup
implements ControlGroup {
    private static final String VERTICAL_CHILD_GAP = "vertical_child_gap";
    private RevertingProperty mSetChildDistance;
    private QuantityProperty<LengthUnit> mChildDistance;
    private ChildDistanceChangeListener propertyChangeListener;

    ChildVerticalGapControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetChildDistance = new RevertingProperty();
        this.mChildDistance = new QuantityProperty(VERTICAL_CHILD_GAP, 0.0, 1000.0, 0.1, (Enum)LengthUnit.px);
        this.propertyChangeListener = new ChildDistanceChangeListener(this.mSetChildDistance, new IPropertyControl[]{this.mChildDistance});
        this.mSetChildDistance.addPropertyChangeListener(this.propertyChangeListener);
        this.mChildDistance.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mChildDistance.appendToForm(formBuilder);
        this.mSetChildDistance.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class ChildDistanceChangeListener
    extends ControlGroupChangeListener {
        public ChildDistanceChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MLocationController locationController = (MLocationController)Controller.getCurrentModeController().getExtension(LocationController.class);
            locationController.setCommonVGapBetweenChildren(node, (Quantity<LengthUnit>)(enabled ? ChildVerticalGapControlGroup.this.mChildDistance.getQuantifiedValue() : LocationModel.DEFAULT_VGAP));
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            ModeController modeController = Controller.getCurrentModeController();
            LocationModel locationModel = LocationModel.getModel((NodeModel)node);
            LocationController locationController = (LocationController)modeController.getExtension(LocationController.class);
            Quantity gap = locationModel.getVGap();
            Quantity viewGap = locationController.getCommonVGapBetweenChildren(node);
            ChildVerticalGapControlGroup.this.mSetChildDistance.setValue(gap != LocationModel.DEFAULT_VGAP);
            ChildVerticalGapControlGroup.this.mChildDistance.setQuantifiedValue(viewGap);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)ChildVerticalGapControlGroup.this.mSetChildDistance);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)ChildVerticalGapControlGroup.this.mChildDistance);
        }
    }
}

