/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.EnumMap;
import java.util.Map;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.filter.Filter;
import org.freeplane.view.swing.map.outline.OutlineDisplayMode;
import org.freeplane.view.swing.map.outline.OutlineTreeViewState;

class OutlineTreeViewStates {
    static final String OUTLINE_DISPLAY_MODE_SYNC_PROPERTY = "outline.displayMode";
    private OutlineDisplayMode currentMode;
    private boolean followsJumpIn;
    private Filter filter;
    private final EnumMap<OutlineDisplayMode, OutlineTreeViewState> viewStatesByMode;

    OutlineTreeViewStates() {
        this(OutlineTreeViewStates.defaultMode(), true, null, new EnumMap<OutlineDisplayMode, OutlineTreeViewState>(OutlineDisplayMode.class));
    }

    private static OutlineDisplayMode defaultMode() {
        return ResourceController.getResourceController().getBooleanProperty(OUTLINE_DISPLAY_MODE_SYNC_PROPERTY, false) ? OutlineDisplayMode.MAP_VIEW_SYNC : OutlineDisplayMode.MAP_VIEW;
    }

    OutlineTreeViewStates(OutlineDisplayMode currentMode, boolean followsJumpIn, Filter filter, EnumMap<OutlineDisplayMode, OutlineTreeViewState> viewStatesByMode) {
        this.followsJumpIn = followsJumpIn;
        this.filter = filter;
        this.currentMode = currentMode != null ? currentMode : OutlineDisplayMode.MAP_VIEW;
        this.viewStatesByMode = viewStatesByMode;
    }

    OutlineTreeViewStates copy() {
        return new OutlineTreeViewStates(this.currentMode, this.followsJumpIn, this.filter, new EnumMap<OutlineDisplayMode, OutlineTreeViewState>(this.viewStatesByMode));
    }

    boolean followsJumpIn() {
        return this.followsJumpIn;
    }

    void setFollowsJumpIn(boolean followsJumpIn) {
        this.followsJumpIn = followsJumpIn;
    }

    Filter getFilter() {
        return this.filter;
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    OutlineDisplayMode getCurrentMode() {
        return this.currentMode;
    }

    void setCurrentMode(OutlineDisplayMode mode) {
        if (mode != null) {
            this.currentMode = mode;
        }
    }

    OutlineTreeViewState getViewState() {
        return this.viewStatesByMode.get((Object)this.currentMode.baseMode());
    }

    void putViewState(OutlineTreeViewState state) {
        OutlineDisplayMode stateKey = this.currentMode.baseMode();
        if (state == null) {
            this.viewStatesByMode.remove((Object)stateKey);
        } else {
            this.viewStatesByMode.put(stateKey, state);
        }
    }

    void loadFrom(OutlineTreeViewStates other) {
        if (other == null) {
            return;
        }
        this.currentMode = other.currentMode;
        this.viewStatesByMode.clear();
        this.viewStatesByMode.putAll(other.viewStatesByMode);
    }

    void loadFromMap(Map<?, ?> storedStates) {
        this.viewStatesByMode.clear();
        if (storedStates == null) {
            return;
        }
        for (Map.Entry<?, ?> entry : storedStates.entrySet()) {
            if (!(entry.getKey() instanceof OutlineDisplayMode) || !(entry.getValue() instanceof OutlineTreeViewState)) continue;
            this.viewStatesByMode.put((OutlineDisplayMode)((Object)entry.getKey()), (OutlineTreeViewState)entry.getValue());
        }
    }
}

