﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/UnsuccessfulItem.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class ReleaseHostsResponse {
 public:
  AWS_EC2_API ReleaseHostsResponse() = default;
  AWS_EC2_API ReleaseHostsResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API ReleaseHostsResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The IDs of the Dedicated Hosts that were successfully released.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSuccessful() const { return m_successful; }
  template <typename SuccessfulT = Aws::Vector<Aws::String>>
  void SetSuccessful(SuccessfulT&& value) {
    m_successfulHasBeenSet = true;
    m_successful = std::forward<SuccessfulT>(value);
  }
  template <typename SuccessfulT = Aws::Vector<Aws::String>>
  ReleaseHostsResponse& WithSuccessful(SuccessfulT&& value) {
    SetSuccessful(std::forward<SuccessfulT>(value));
    return *this;
  }
  template <typename SuccessfulT = Aws::String>
  ReleaseHostsResponse& AddSuccessful(SuccessfulT&& value) {
    m_successfulHasBeenSet = true;
    m_successful.emplace_back(std::forward<SuccessfulT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IDs of the Dedicated Hosts that could not be released, including an error
   * message.</p>
   */
  inline const Aws::Vector<UnsuccessfulItem>& GetUnsuccessful() const { return m_unsuccessful; }
  template <typename UnsuccessfulT = Aws::Vector<UnsuccessfulItem>>
  void SetUnsuccessful(UnsuccessfulT&& value) {
    m_unsuccessfulHasBeenSet = true;
    m_unsuccessful = std::forward<UnsuccessfulT>(value);
  }
  template <typename UnsuccessfulT = Aws::Vector<UnsuccessfulItem>>
  ReleaseHostsResponse& WithUnsuccessful(UnsuccessfulT&& value) {
    SetUnsuccessful(std::forward<UnsuccessfulT>(value));
    return *this;
  }
  template <typename UnsuccessfulT = UnsuccessfulItem>
  ReleaseHostsResponse& AddUnsuccessful(UnsuccessfulT&& value) {
    m_unsuccessfulHasBeenSet = true;
    m_unsuccessful.emplace_back(std::forward<UnsuccessfulT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ReleaseHostsResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_successful;

  Aws::Vector<UnsuccessfulItem> m_unsuccessful;

  ResponseMetadata m_responseMetadata;
  bool m_successfulHasBeenSet = false;
  bool m_unsuccessfulHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
