﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/outposts/Outposts_EXPORTS.h>
#include <aws/outposts/model/CapacityTaskFailureType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Outposts {
namespace Model {

/**
 * <p>The capacity tasks that failed.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CapacityTaskFailure">AWS
 * API Reference</a></p>
 */
class CapacityTaskFailure {
 public:
  AWS_OUTPOSTS_API CapacityTaskFailure() = default;
  AWS_OUTPOSTS_API CapacityTaskFailure(Aws::Utils::Json::JsonView jsonValue);
  AWS_OUTPOSTS_API CapacityTaskFailure& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OUTPOSTS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The reason that the specified capacity task failed.</p>
   */
  inline const Aws::String& GetReason() const { return m_reason; }
  inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }
  template <typename ReasonT = Aws::String>
  void SetReason(ReasonT&& value) {
    m_reasonHasBeenSet = true;
    m_reason = std::forward<ReasonT>(value);
  }
  template <typename ReasonT = Aws::String>
  CapacityTaskFailure& WithReason(ReasonT&& value) {
    SetReason(std::forward<ReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of failure.</p>
   */
  inline CapacityTaskFailureType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(CapacityTaskFailureType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline CapacityTaskFailure& WithType(CapacityTaskFailureType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_reason;
  bool m_reasonHasBeenSet = false;

  CapacityTaskFailureType m_type{CapacityTaskFailureType::NOT_SET};
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Outposts
}  // namespace Aws
