/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.compliance;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.get.GetResult;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.security.compliance.ComplianceIndexingOperationListener;
import org.opensearch.threadpool.ThreadPool;

public final class ComplianceIndexingOperationListenerImpl
extends ComplianceIndexingOperationListener {
    private static final Logger log = LogManager.getLogger(ComplianceIndexingOperationListenerImpl.class);
    private final AuditLog auditlog;
    private final ThreadPool threadPool;
    private volatile IndexService is;
    private static final ThreadLocal<Context> threadContext = new ThreadLocal();

    public ComplianceIndexingOperationListenerImpl(AuditLog auditlog, ThreadPool threadPool) {
        this.auditlog = auditlog;
        this.threadPool = threadPool;
    }

    @Override
    public void setIs(IndexService is) {
        if (this.is != null) {
            throw new OpenSearchException("Index service already set", new Object[0]);
        }
        this.is = is;
    }

    private void retrieveOriginalDocumentForDiff(ShardId shardId, String documentId, long ifSeqNo, long ifPrimaryTerm, Engine.Operation.Origin origin) {
        block14: {
            if (!ComplianceIndexingOperationListenerImpl.isLoggingWriteDiffEnabled(this.auditlog.getComplianceConfig(), shardId.getIndexName())) {
                return;
            }
            Objects.requireNonNull(this.is);
            if (origin != Engine.Operation.Origin.PRIMARY) {
                return;
            }
            IndexShard shard = this.is.getShardOrNull(shardId.getId());
            if (shard == null) {
                return;
            }
            if (shard.isReadAllowed()) {
                try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                    this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
                    GetResult getResult = shard.getService().getForUpdate(documentId, ifSeqNo, ifPrimaryTerm);
                    threadContext.set(new Context((GetResult)(getResult.isExists() ? getResult : null)));
                    break block14;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Cannot retrieve original document due to {}", (Object)e.toString());
                    }
                    break block14;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Cannot read from shard {}", (Object)shardId);
            }
        }
    }

    private GetResult retrieveAndCleanupContext() {
        Context context = threadContext.get();
        GetResult previousContent = context == null ? null : context.getGetResult();
        threadContext.remove();
        return previousContent;
    }

    public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        this.retrieveOriginalDocumentForDiff(shardId, delete.id(), delete.getIfSeqNo(), delete.getIfPrimaryTerm(), delete.origin());
        return delete;
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        ComplianceConfig complianceConfig = this.auditlog.getComplianceConfig();
        if (ComplianceIndexingOperationListenerImpl.isLoggingWriteEnabled(complianceConfig, shardId.getIndexName())) {
            Objects.requireNonNull(this.is);
            if (result.getFailure() == null && result.isFound() && delete.origin() == Engine.Operation.Origin.PRIMARY) {
                if (complianceConfig.shouldLogDiffsForWrite()) {
                    GetResult previousContent = this.retrieveAndCleanupContext();
                    this.auditlog.logDocumentDeleted(shardId, delete, result, previousContent);
                } else {
                    this.auditlog.logDocumentDeleted(shardId, delete, result, null);
                }
            }
        }
        if (ComplianceIndexingOperationListenerImpl.isLoggingWriteDiffEnabled(complianceConfig, shardId.getIndexName())) {
            threadContext.remove();
        }
    }

    public Engine.Index preIndex(ShardId shardId, Engine.Index index) {
        this.retrieveOriginalDocumentForDiff(shardId, index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm(), index.origin());
        return index;
    }

    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (ComplianceIndexingOperationListenerImpl.isLoggingWriteDiffEnabled(this.auditlog.getComplianceConfig(), shardId.getIndexName())) {
            threadContext.remove();
        }
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        ComplianceConfig complianceConfig = this.auditlog.getComplianceConfig();
        if (!ComplianceIndexingOperationListenerImpl.isLoggingWriteEnabled(complianceConfig, shardId.getIndexName())) {
            return;
        }
        if (complianceConfig.shouldLogDiffsForWrite()) {
            GetResult previousContent = this.retrieveAndCleanupContext();
            Objects.requireNonNull(this.is);
            if (result.getFailure() != null || index.origin() != Engine.Operation.Origin.PRIMARY) {
                return;
            }
            if (this.is.getShardOrNull(shardId.getId()) == null) {
                return;
            }
            if (previousContent == null) {
                if (!result.isCreated()) {
                    log.warn("No previous content and not created (its an update but do not find orig source) for {}/{}/{}", (Object)index.startTime(), (Object)shardId, (Object)index.id());
                }
                assert (result.isCreated()) : "No previous content and not created";
            } else {
                if (result.isCreated()) {
                    log.warn("Previous content and created for {}/{}/{}", (Object)index.startTime(), (Object)shardId, (Object)index.id());
                }
                assert (!result.isCreated()) : "Previous content and created";
            }
            this.auditlog.logDocumentWritten(shardId, previousContent, index, result);
        } else {
            if (result.getFailure() != null || index.origin() != Engine.Operation.Origin.PRIMARY) {
                return;
            }
            this.auditlog.logDocumentWritten(shardId, null, index, result);
        }
    }

    private static boolean isLoggingWriteEnabled(ComplianceConfig complianceConfig, String indexName) {
        return complianceConfig != null && complianceConfig.writeHistoryEnabledForIndex(indexName);
    }

    private static boolean isLoggingWriteDiffEnabled(ComplianceConfig complianceConfig, String indexName) {
        return ComplianceIndexingOperationListenerImpl.isLoggingWriteEnabled(complianceConfig, indexName) && complianceConfig.shouldLogDiffsForWrite();
    }

    private static final class Context {
        private final GetResult getResult;

        public Context(GetResult getResult) {
            this.getResult = getResult;
        }

        public GetResult getGetResult() {
            return this.getResult;
        }
    }
}

