/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.selectivem.collections.CheckTable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.security.privileges.PrivilegesEvaluationException;

public class PrivilegesEvaluatorResponse {
    private final boolean allowed;
    private final CreateIndexRequestBuilder createIndexRequestBuilder;
    private final ImmutableSet<String> onlyAllowedForIndices;
    private final CheckTable<String, String> indexToActionCheckTable;
    private String privilegeMatrix;
    private final String reason;
    private ImmutableList<PrivilegesEvaluationException> evaluationExceptions;

    public PrivilegesEvaluatorResponse(boolean allowed, ImmutableSet<String> onlyAllowedForIndices, CheckTable<String, String> indexToActionCheckTable, String privilegeMatrix, String reason, ImmutableList<PrivilegesEvaluationException> evaluationExceptions, CreateIndexRequestBuilder createIndexRequestBuilder) {
        this.allowed = allowed;
        this.createIndexRequestBuilder = createIndexRequestBuilder;
        this.onlyAllowedForIndices = onlyAllowedForIndices;
        this.indexToActionCheckTable = indexToActionCheckTable;
        this.privilegeMatrix = privilegeMatrix;
        this.reason = reason;
        this.evaluationExceptions = evaluationExceptions;
    }

    public PrivilegesEvaluatorResponse(boolean allowed, ImmutableSet<String> onlyAllowedForIndices, CheckTable<String, String> indexToActionCheckTable) {
        this.allowed = allowed;
        this.createIndexRequestBuilder = null;
        this.onlyAllowedForIndices = onlyAllowedForIndices;
        this.indexToActionCheckTable = indexToActionCheckTable;
        this.privilegeMatrix = null;
        this.reason = null;
        this.evaluationExceptions = ImmutableList.of();
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean isPartiallyOk() {
        return !this.onlyAllowedForIndices.isEmpty();
    }

    public Set<String> getAvailableIndices() {
        return this.onlyAllowedForIndices;
    }

    public Set<String> getMissingPrivileges() {
        return this.indexToActionCheckTable != null ? this.indexToActionCheckTable.getIncompleteColumns() : Collections.emptySet();
    }

    public String getReason() {
        return this.reason;
    }

    public PrivilegesEvaluatorResponse reason(String reason) {
        return new PrivilegesEvaluatorResponse(this.allowed, this.onlyAllowedForIndices, this.indexToActionCheckTable, this.privilegeMatrix, reason, this.evaluationExceptions, this.createIndexRequestBuilder);
    }

    public String getEvaluationExceptionInfo() {
        StringBuilder result = new StringBuilder("Exceptions encountered during privilege evaluation:\n");
        for (PrivilegesEvaluationException evaluationException : this.evaluationExceptions) {
            result.append(evaluationException.getNestedMessages()).append("\n");
        }
        return result.toString();
    }

    public boolean hasEvaluationExceptions() {
        return !this.evaluationExceptions.isEmpty();
    }

    public PrivilegesEvaluatorResponse evaluationExceptions(Collection<PrivilegesEvaluationException> evaluationExceptions) {
        if (evaluationExceptions.isEmpty()) {
            return this;
        }
        return new PrivilegesEvaluatorResponse(this.allowed, this.onlyAllowedForIndices, this.indexToActionCheckTable, this.privilegeMatrix, this.reason, (ImmutableList<PrivilegesEvaluationException>)ImmutableList.builder().addAll(this.evaluationExceptions).addAll(evaluationExceptions).build(), this.createIndexRequestBuilder);
    }

    public String getPrivilegeMatrix() {
        String result = this.privilegeMatrix;
        if (result == null) {
            this.privilegeMatrix = result = this.indexToActionCheckTable.toTableString("ok", "MISSING");
        }
        return result;
    }

    public CreateIndexRequestBuilder getCreateIndexRequestBuilder() {
        return this.createIndexRequestBuilder;
    }

    public PrivilegesEvaluatorResponse with(CreateIndexRequestBuilder createIndexRequestBuilder) {
        if (createIndexRequestBuilder == this.createIndexRequestBuilder) {
            return this;
        }
        return new PrivilegesEvaluatorResponse(this.allowed, this.onlyAllowedForIndices, this.indexToActionCheckTable, this.privilegeMatrix, this.reason, this.evaluationExceptions, createIndexRequestBuilder);
    }

    public String toString() {
        return "PrivEvalResponse [\nallowed=" + this.allowed + ",\nonlyAllowedForIndices=" + String.valueOf(this.onlyAllowedForIndices) + ",\n" + (this.indexToActionCheckTable != null ? this.indexToActionCheckTable.toTableString("ok", "MISSING") : "") + "]";
    }

    public static PrivilegesEvaluatorResponse ok() {
        return new PrivilegesEvaluatorResponse(true, (ImmutableSet<String>)ImmutableSet.of(), null);
    }

    public static PrivilegesEvaluatorResponse partiallyOk(Set<String> availableIndices, CheckTable<String, String> indexToActionCheckTable) {
        return new PrivilegesEvaluatorResponse(false, (ImmutableSet<String>)ImmutableSet.copyOf(availableIndices), indexToActionCheckTable);
    }

    public static PrivilegesEvaluatorResponse insufficient(String missingPrivilege) {
        return new PrivilegesEvaluatorResponse(false, (ImmutableSet<String>)ImmutableSet.of(), (CheckTable<String, String>)CheckTable.create((Set)ImmutableSet.of((Object)"_"), (Set)ImmutableSet.of((Object)missingPrivilege)));
    }

    public static PrivilegesEvaluatorResponse insufficient(CheckTable<String, String> indexToActionCheckTable) {
        return new PrivilegesEvaluatorResponse(false, (ImmutableSet<String>)ImmutableSet.of(), indexToActionCheckTable);
    }
}

