/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.segments.PitSegmentsRequest;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.privileges.ActionPrivileges;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;

public class PitPrivilegesEvaluator {
    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, PrivilegesEvaluationContext context, ActionPrivileges actionPrivileges, String action, IndexResolverReplacer irr) {
        if (!(request instanceof DeletePitRequest) && !(request instanceof PitSegmentsRequest)) {
            return null;
        }
        List<String> pitIds = new ArrayList();
        if (request instanceof DeletePitRequest) {
            DeletePitRequest deletePitRequest = (DeletePitRequest)request;
            pitIds = deletePitRequest.getPitIds();
        } else if (request instanceof PitSegmentsRequest) {
            PitSegmentsRequest pitSegmentsRequest = (PitSegmentsRequest)request;
            pitIds = pitSegmentsRequest.getPitIds();
        }
        if (pitIds.size() == 1 && "_all".equals(pitIds.get(0))) {
            return null;
        }
        return this.handlePitsAccess(pitIds, context, actionPrivileges, action, irr);
    }

    private PrivilegesEvaluatorResponse handlePitsAccess(List<String> pitIds, PrivilegesEvaluationContext context, ActionPrivileges actionPrivileges, String action, IndexResolverReplacer irr) {
        Map pitToIndicesMap = OpenSearchSecurityPlugin.GuiceHolder.getPitService().getIndicesForPits(pitIds);
        HashSet<String> pitIndices = new HashSet<String>();
        for (String[] indices : pitToIndicesMap.values()) {
            pitIndices.addAll(Arrays.asList(indices));
        }
        String[] indicesArr = new String[pitIndices.size()];
        CreatePitRequest req = new CreatePitRequest(new TimeValue(1L, TimeUnit.DAYS), Boolean.valueOf(true), pitIndices.toArray(indicesArr));
        IndexResolverReplacer.Resolved pitResolved = irr.resolveRequest(req);
        PrivilegesEvaluatorResponse subResponse = actionPrivileges.hasIndexPrivilege(context, (Set<String>)ImmutableSet.of((Object)action), pitResolved);
        if (subResponse.isAllowed()) {
            return PrivilegesEvaluatorResponse.ok();
        }
        return null;
    }
}

