/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;

public class CookieManager
extends AbstractInitializableComponent {
    @Nullable
    private String cookiePath;
    @Nullable
    private String cookieDomain;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpRequestSupplier;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletResponse> httpResponseSupplier;
    private boolean secure = true;
    private boolean httpOnly = true;
    private int maxAge = -1;

    @Nullable
    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(@Nullable String path) {
        this.checkSetterPreconditions();
        this.cookiePath = StringSupport.trimOrNull(path);
    }

    @Nullable
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(@Nullable String domain) {
        this.checkSetterPreconditions();
        this.cookieDomain = StringSupport.trimOrNull(domain);
    }

    public void setHttpServletRequestSupplier(@Nonnull NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpRequestSupplier = Constraint.isNotNull(requestSupplier, "HttpServletRequest cannot be null");
    }

    @NonnullAfterInit
    protected HttpServletRequest getHttpServletRequest() {
        if (this.httpRequestSupplier == null) {
            return null;
        }
        return this.httpRequestSupplier.get();
    }

    public void setHttpServletResponseSupplier(@Nonnull NonnullSupplier<HttpServletResponse> responseSupplier) {
        this.checkSetterPreconditions();
        this.httpResponseSupplier = Constraint.isNotNull(responseSupplier, "HttpServletResponse cannot be null");
    }

    @NonnullAfterInit
    protected HttpServletResponse getHttpServletResponse() {
        if (this.httpResponseSupplier == null) {
            return null;
        }
        return this.httpResponseSupplier.get();
    }

    public void setSecure(boolean flag) {
        this.checkSetterPreconditions();
        this.secure = flag;
    }

    public void setHttpOnly(boolean flag) {
        this.checkSetterPreconditions();
        this.httpOnly = flag;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int age) {
        this.checkSetterPreconditions();
        this.maxAge = age;
    }

    public void setMaxAgeDuration(@Nonnull Duration age) {
        this.checkSetterPreconditions();
        this.maxAge = (int)Constraint.isNotNull(age, "Age cannot be null").getSeconds();
        if (this.maxAge < 0) {
            this.maxAge = -1;
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpRequestSupplier == null || this.httpResponseSupplier == null) {
            throw new ComponentInitializationException("Servlet request and response must be set");
        }
    }

    public void addCookie(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String value) {
        this.addCookie(name, value, this.maxAge);
    }

    protected void addCookie(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String value, int overrideMaxAge) {
        this.checkComponentActive();
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this.cookiePath != null ? this.cookiePath : this.contextPathToCookiePath());
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        cookie.setSecure(this.secure);
        cookie.setHttpOnly(this.httpOnly);
        cookie.setMaxAge(overrideMaxAge);
        this.getHttpServletResponse().addCookie(cookie);
    }

    public void unsetCookie(@Nonnull @NotEmpty String name) {
        this.checkComponentActive();
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(this.cookiePath != null ? this.cookiePath : this.contextPathToCookiePath());
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        cookie.setSecure(this.secure);
        cookie.setHttpOnly(this.httpOnly);
        cookie.setMaxAge(0);
        this.getHttpServletResponse().addCookie(cookie);
    }

    public boolean cookieHasValue(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String expectedValue) {
        String realValue = this.getCookieValue(name, null);
        if (realValue == null) {
            return false;
        }
        return realValue.equals(expectedValue);
    }

    @Nullable
    public String getCookieValue(@Nonnull @NotEmpty String name, @Nullable String defValue) {
        this.checkComponentActive();
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return defValue;
    }

    @Nonnull
    @NotEmpty
    private String contextPathToCookiePath() {
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        return "".equals(httpRequest.getContextPath()) ? "/" : httpRequest.getContextPath();
    }
}

