/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;

final class Values<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = -637982217747670311L;
    private final Row[] rows;

    Values(Row[] rows) {
        super("values");
        this.rows = Values.assertNotEmpty(rows);
    }

    static Row[] assertNotEmpty(Row[] rows) {
        if (rows == null || rows.length == 0) {
            throw new IllegalArgumentException("Cannot create a VALUES() constructor with an empty set of rows");
        }
        return rows;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final Table<R> as(Name alias) {
        return new TableAlias(this, alias, true);
    }

    @Override
    public final Table<R> as(Name alias, Name ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, true);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case MARIADB: 
            case MYSQL: {
                Select<Record> selects = null;
                boolean subquery = ctx.subquery();
                for (Row row : this.rows) {
                    SelectSelectStep<Record> select = this.create().select(row.fields());
                    selects = selects == null ? select : selects.unionAll(select);
                }
                ctx.formatIndentStart().formatNewLine().subquery(true).visit(selects).subquery(subquery).formatIndentEnd().formatNewLine();
                break;
            }
            default: {
                ctx.start(Clause.TABLE_VALUES).visit(Keywords.K_VALUES);
                if (this.rows.length > 1) {
                    ctx.formatIndentStart().formatSeparator();
                }
                for (int i = 0; i < this.rows.length; ++i) {
                    if (i > 0) {
                        ctx.sql(',').formatSeparator();
                    }
                    ctx.visit(this.rows[i]);
                }
                if (this.rows.length > 1) {
                    ctx.formatIndentEnd().formatNewLine();
                }
                ctx.end(Clause.TABLE_VALUES);
            }
        }
    }

    @Override
    final Fields<R> fields0() {
        return new Fields(this.rows[0].fields());
    }
}

