/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.chunker;

import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.opensearch.neuralsearch.processor.chunker.DelimiterChunker;
import org.opensearch.neuralsearch.processor.chunker.FixedCharLengthChunker;
import org.opensearch.neuralsearch.processor.chunker.FixedTokenLengthChunker;
import org.opensearch.neuralsearch.processor.chunker.Validator;

public class ChunkerValidatorFactory {
    private final Map<String, Validator> ALGORITHM_TO_VALIDATOR = Map.of("fixed_token_length", new FixedTokenLengthChunker(), "delimiter", new DelimiterChunker(), "fixed_char_length", new FixedCharLengthChunker());

    public Validator getValidator(@NonNull String algorithm) {
        Objects.requireNonNull(algorithm, "algorithm is marked non-null but is null");
        return this.ALGORITHM_TO_VALIDATOR.get(algorithm);
    }
}

