/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunScheduledInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RunScheduledInstancesResponse> {
    private static final SdkField<List<String>> INSTANCE_ID_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIdSet").getter(RunScheduledInstancesResponse.getter(RunScheduledInstancesResponse::instanceIdSet)).setter(RunScheduledInstancesResponse.setter(Builder::instanceIdSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdSet").unmarshallLocationName("instanceIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RunScheduledInstancesResponse.memberNameToFieldInitializer();
    private final List<String> instanceIdSet;

    private RunScheduledInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceIdSet = builder.instanceIdSet;
    }

    public final boolean hasInstanceIdSet() {
        return this.instanceIdSet != null && !(this.instanceIdSet instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIdSet() {
        return this.instanceIdSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIdSet() ? this.instanceIdSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesResponse)) {
            return false;
        }
        RunScheduledInstancesResponse other = (RunScheduledInstancesResponse)((Object)obj);
        return this.hasInstanceIdSet() == other.hasInstanceIdSet() && Objects.equals(this.instanceIdSet(), other.instanceIdSet());
    }

    public final String toString() {
        return ToString.builder((String)"RunScheduledInstancesResponse").add("InstanceIdSet", this.hasInstanceIdSet() ? this.instanceIdSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIdSet": {
                return Optional.ofNullable(clazz.cast(this.instanceIdSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("InstanceIdSet", INSTANCE_ID_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunScheduledInstancesResponse, T> g) {
        return obj -> g.apply((RunScheduledInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<String> instanceIdSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesResponse model) {
            super(model);
            this.instanceIdSet(model.instanceIdSet);
        }

        public final Collection<String> getInstanceIdSet() {
            if (this.instanceIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIdSet;
        }

        public final void setInstanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
        }

        @Override
        public final Builder instanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIdSet(String ... instanceIdSet) {
            this.instanceIdSet(Arrays.asList(instanceIdSet));
            return this;
        }

        @Override
        public RunScheduledInstancesResponse build() {
            return new RunScheduledInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunScheduledInstancesResponse> {
        public Builder instanceIdSet(Collection<String> var1);

        public Builder instanceIdSet(String ... var1);
    }
}

