"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@osd/config-schema");
var _constants = require("../constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @internal
 */

const config = exports.config = {
  path: 'csp-report-only',
  schema: _configSchema.schema.object({
    isEmitting: _configSchema.schema.boolean({
      defaultValue: false
    }),
    rules: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: [`default-src 'self'`, `script-src 'self'`, `script-src-attr 'none'`, `style-src 'self'`, `style-src-elem 'self'`, `style-src-attr 'self' 'unsafe-inline'`, `child-src 'none'`, `worker-src 'self'`, `frame-src 'none'`, `object-src 'none'`, `manifest-src 'self'`, `media-src 'none'`, `font-src 'self'`, `connect-src 'self' ${_constants.CSP_TRUSTED_ENDPOINTS.join(' ')}`, `img-src 'self' data: ${_constants.CSP_TRUSTED_ENDPOINTS.join(' ')}`, `form-action 'self'`, `frame-ancestors 'self'`]
    }),
    nonceDirectives: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: ['style-src-elem']
    }),
    endpoint: _configSchema.schema.maybe(_configSchema.schema.string()),
    useDeprecatedReportUriOnly: _configSchema.schema.boolean({
      defaultValue: false
    }),
    allowedFrameAncestorSources: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    allowedConnectSources: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    allowedImgSources: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  })
};