"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseActions = void 0;
var _state_adapter = require("./state_adapter");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
/*
 * @experimental
 */
class BaseActions {
  // Keep for backward compatibility

  constructor(adapterOrSubject) {
    _defineProperty(this, "stateAdapter", void 0);
    _defineProperty(this, "state$", void 0);
    if ((0, _state_adapter.isStateAdapter)(adapterOrSubject)) {
      this.stateAdapter = adapterOrSubject;
    } else {
      const subject = adapterOrSubject;
      this.state$ = subject; // Store for backward compatibility
      this.stateAdapter = new _state_adapter.BehaviorSubjectAdapter(subject);
    }
  }
  updateState(updater) {
    this.stateAdapter.setState(updater);
  }
}
exports.BaseActions = BaseActions;