﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/ReviewTemplateLensReview.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {
class GetReviewTemplateLensReviewResult {
 public:
  AWS_WELLARCHITECTED_API GetReviewTemplateLensReviewResult() = default;
  AWS_WELLARCHITECTED_API GetReviewTemplateLensReviewResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WELLARCHITECTED_API GetReviewTemplateLensReviewResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The review template ARN.</p>
   */
  inline const Aws::String& GetTemplateArn() const { return m_templateArn; }
  template <typename TemplateArnT = Aws::String>
  void SetTemplateArn(TemplateArnT&& value) {
    m_templateArnHasBeenSet = true;
    m_templateArn = std::forward<TemplateArnT>(value);
  }
  template <typename TemplateArnT = Aws::String>
  GetReviewTemplateLensReviewResult& WithTemplateArn(TemplateArnT&& value) {
    SetTemplateArn(std::forward<TemplateArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A lens review of a question.</p>
   */
  inline const ReviewTemplateLensReview& GetLensReview() const { return m_lensReview; }
  template <typename LensReviewT = ReviewTemplateLensReview>
  void SetLensReview(LensReviewT&& value) {
    m_lensReviewHasBeenSet = true;
    m_lensReview = std::forward<LensReviewT>(value);
  }
  template <typename LensReviewT = ReviewTemplateLensReview>
  GetReviewTemplateLensReviewResult& WithLensReview(LensReviewT&& value) {
    SetLensReview(std::forward<LensReviewT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetReviewTemplateLensReviewResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_templateArn;

  ReviewTemplateLensReview m_lensReview;

  Aws::String m_requestId;
  bool m_templateArnHasBeenSet = false;
  bool m_lensReviewHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
