/*
 * This source file is part of libRocket, the HTML/CSS Interface Middleware
 *
 * For the latest information, see http://www.librocket.com
 *
 * Copyright (c) 2008-2010 CodePoint Ltd, Shift Technology Ltd
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#include "InputType.h"
#include "../../Include/Rocket/Controls/ElementFormControlInput.h"

namespace Rocket {
namespace Controls {

InputType::InputType(ElementFormControlInput* element) : element(element)
{
}

InputType::~InputType()
{
}

// Returns a string representation of the current value of the form control.
Rocket::Core::String InputType::GetValue() const
{
	return element->GetAttribute< Rocket::Core::String >("value", "");
}

// Returns if this value should be submitted with the form.
bool InputType::IsSubmitted()
{
	return true;
}

// Called every update from the host element.
void InputType::OnUpdate()
{
}

// Called every render from the host element.
void InputType::OnRender()
{
}

// Checks for necessary functional changes in the control as a result of changed attributes.
bool InputType::OnAttributeChange(const Core::AttributeNameList& ROCKET_UNUSED_PARAMETER(changed_attributes))
{
	ROCKET_UNUSED(changed_attributes);

	return true;
}

// Called when properties on the control are changed.
void InputType::OnPropertyChange(const Core::PropertyNameList& ROCKET_UNUSED_PARAMETER(changed_properties))
{
	ROCKET_UNUSED(changed_properties);
}

// Called when the element is added into a hierarchy.
void InputType::OnChildAdd()
{
}

// Called when the element is removed from a hierarchy.
void InputType::OnChildRemove()
{
}

}
}
