/*****
*
* Copyright (C) 2005-2020 CS GROUP - France. All Rights Reserved.
* Author: Yoann Vandoorselaere <yoann.v@prelude-ids.com>
*
* This file is part of the PreludeDB library.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*****/

#ifndef _LIBPRELUDEDB_VERSION_H
#define _LIBPRELUDEDB_VERSION_H

#ifdef __cplusplus
 extern "C" {
#endif

#define LIBPRELUDEDB_VERSION "5.2.0"

#define LIBPRELUDEDB_RELEASE_LEVEL_ALPHA  0xa
#define LIBPRELUDEDB_RELEASE_LEVEL_BETA   0xb
#define LIBPRELUDEDB_RELEASE_LEVEL_RC     0xc
#define LIBPRELUDEDB_RELEASE_LEVEL_FINAL  0xf

#define LIBPRELUDEDB_MAJOR_VERSION  5
#define LIBPRELUDEDB_MINOR_VERSION  2
#define LIBPRELUDEDB_MICRO_VERSION  0
#define LIBPRELUDEDB_LEVEL_VERSION  LIBPRELUDEDB_RELEASE_LEVEL_FINAL
#define LIBPRELUDEDB_SERIAL_VERSION  0


#define LIBPRELUDEDB_HEXVERSION  ((LIBPRELUDEDB_MAJOR_VERSION << 24) | \
                                  (LIBPRELUDEDB_MINOR_VERSION << 16) | \
                                  (LIBPRELUDEDB_MICRO_VERSION <<  8) | \
                                  (LIBPRELUDEDB_LEVEL_VERSION <<  4) | \
                                  (LIBPRELUDEDB_SERIAL_VERSION << 0))

const char *preludedb_check_version(const char *req_version);

#ifdef __cplusplus
  }
#endif

#endif /* _LIBPRELUDEDB_VERSION_H */
