from PySide6.QtWidgets import QVBoxLayout, QLineEdit

PLACEHOLDER_TEXTS = {
    "nmap": "Enter switch (e.g., -p 80 192.168.0.1)",
    "bettercap": "Enter switch (e.g., --proxy)",
    "sqlmap": "Enter switch (e.g., -u 'http://example.com')",
    "netexec": "Enter switch (e.g., --help)",
    "evil-winrm": "Enter switch (e.g., --help)",
    "wpscan": "Enter switch (e.g., --help)",
    "katana": "Enter switch (e.g., --help)",
    "subfinder": "Enter switch (e.g., --help)",
    "tshark": "Enter switch (e.g., -h)",
}

class SwitchSection:
    SUPPORTED_TOOLS = {
        "nmap", "bettercap", "sqlmap",
        "netexec", "evil-winrm", "wpscan",
        "katana", "subfinder", "tshark"
    }

    def __init__(self, parent):
        self.parent = parent
        self.tool = parent.tool

    @staticmethod
    def get_placeholder_text(tool_name: str) -> str:
        return PLACEHOLDER_TEXTS.get(tool_name, "Enter switch for the tool")

    def create_switch_section(self) -> QVBoxLayout:
        """
        Creates the switch input section for the tool card.
        """
        layout = QVBoxLayout()
        tool_name = self.tool["name"].lower()
        if tool_name in self.SUPPORTED_TOOLS:
            switch_input = QLineEdit(self.parent)
            switch_input.setPlaceholderText(self.get_placeholder_text(tool_name))
            layout.addWidget(switch_input)
            self.parent.switch_input = switch_input
        return layout

