"""Module for managing themes for the application's GUI."""

# Consts Colors Generic
from src.resources.themes.colors import WHITE, BLACK
# Consts Colors Default Theme
from src.resources.themes.colors import (
    BG_WIDGET_DEFAULT,
    BG_ITEM_DEFAULT,
    BORDER_ITEM_DEFAULT,
    BG_BUTTON_DEFAULT,
    BORDER_BUTTON_DEFAULT,
    BG_ITEM_SELECTED_DEFAULT
)
# Consts Colors Hack The Box Theme
from src.resources.themes.colors import (
    BG_WIDGET_HACKTHEBOX,
    BG_ITEM_HACKTHEBOX,
    BORDER_ITEM_HACKTHEBOX,
    BG_BUTTON_HACKTHEBOX,
    BORDER_BUTTON_HACKTHEBOX,
    BG_ITEM_SELECTED_HACKTHEBOX
)
# Consts Colors Sunset Theme
from src.resources.themes.colors import (
    BG_WIDGET_SUNSET, BG_ITEM_SUNSET,
    BORDER_ITEM_SUNSET,
    BG_BUTTON_SUNSET,
    BORDER_BUTTON_SUNSET,
    BG_ITEM_SELECTED_SUNSET
)

themes = {
    'Default': f"""
        QWidget {{
            background-color: {BG_WIDGET_DEFAULT};
            color: {WHITE};
        }}
        QLineEdit, QTextEdit {{
            background-color: {BG_ITEM_DEFAULT};
            color: {WHITE};
            border: 1px solid {BORDER_ITEM_DEFAULT};
            border-radius: 10px;
            padding: 5px;
        }}
        QPushButton {{
            background-color: {BG_BUTTON_DEFAULT};
            color: {BLACK};
            border: 1px solid {BORDER_BUTTON_DEFAULT};
            padding: 8px 15px;
            border-radius: 10px;
        }}
        QPushButton:hover {{
            background-color: #F5A65B;
            border: 1px solid {WHITE};
        }}
        QPushButton:pressed {{
            background-color: #C4732C;
        }}
        QListWidget, QTreeWidget {{
            background-color: {BG_ITEM_DEFAULT};
            color: {WHITE};
            border-radius: 8px;
            outline: none;
            padding: 5px;
            border: 1px solid {BORDER_ITEM_DEFAULT};
            show-decoration-selected: 0;
        }}
        QListWidget::item, QTreeWidget::item {{
            padding: 6px;
            border-radius: 6px;
            margin: 1px 5px;
        }}
        QListWidget::item:hover, QTreeWidget::item:hover {{
            background-color: #384A7A;
        }}
        QListWidget::item:selected, QTreeWidget::item:selected {{
            background-color: {BG_ITEM_SELECTED_DEFAULT};
            color: {BLACK};
            font-weight: bold;
        }}
        QScrollBar:vertical {{
            border: none;
            background: transparent;
            width: 8px;
            margin: 0px;
        }}
        QScrollBar::handle:vertical {{
            background: #555;
            min-height: 20px;
            border-radius: 4px;
        }}
        QScrollBar::add-line:vertical, QScrollBar::sub-line:vertical {{
            height: 0px;
        }}
        QScrollBar::add-page:vertical, QScrollBar::sub-page:vertical {{
            background: none;
        }}
    """,
    'Hack The Box': f"""
        QWidget {{
            background-color: {BG_WIDGET_HACKTHEBOX};
            color: {WHITE};
        }}
        QLineEdit, QTextEdit {{
            background-color: {BG_ITEM_HACKTHEBOX};
            color: {WHITE};
            border: 1px solid {BORDER_ITEM_HACKTHEBOX};
            border-radius: 10px;
            padding: 5px;
        }}
        QPushButton {{
            background-color: {BG_BUTTON_HACKTHEBOX};
            color: {BLACK};
            border: 1px solid {BORDER_BUTTON_HACKTHEBOX};
            padding: 8px 15px;
            border-radius: 10px;
        }}
        QPushButton:hover {{
            background-color: #79E61A;
            border: 1px solid {WHITE};
        }}
        QPushButton:pressed {{
            background-color: #4FB000;
        }}
        QListWidget, QTreeWidget {{
            background-color: {BG_ITEM_HACKTHEBOX};
            color: {WHITE};
            border-radius: 8px;
            outline: none;
            padding: 5px;
            border: 1px solid {BORDER_ITEM_HACKTHEBOX};
            show-decoration-selected: 0;
        }}
        QListWidget::item, QTreeWidget::item {{
            padding: 6px;
            border-radius: 6px;
            margin: 1px 5px;
        }}
        QListWidget::item:hover, QTreeWidget::item:hover {{
            background-color: #2D3545;
        }}
        QListWidget::item:selected, QTreeWidget::item:selected {{
            background-color: {BG_ITEM_SELECTED_HACKTHEBOX};
            color: {BLACK};
            font-weight: bold;
        }}
        QScrollBar:vertical {{
            border: none;
            background: transparent;
            width: 8px;
            margin: 0px;
        }}
        QScrollBar::handle:vertical {{
            background: #79E61A;
            min-height: 20px;
            border-radius: 4px;
        }}
        QScrollBar::add-line:vertical, QScrollBar::sub-line:vertical {{
            height: 0px;
        }}
        QScrollBar::add-page:vertical, QScrollBar::sub-page:vertical {{
            background: none;
        }}
    """,
    'Sunset': f"""
        QWidget {{
            background-color: {BG_WIDGET_SUNSET};
            color: {WHITE};
        }}
        QLineEdit, QTextEdit {{
            background-color: {BG_ITEM_SUNSET};
            color: {WHITE};
            border: 1px solid {BORDER_ITEM_SUNSET};
            border-radius: 10px;
            padding: 5px;
        }}
        QPushButton {{
            background-color: {BG_BUTTON_SUNSET};
            color: {WHITE};
            border: 1px solid {BORDER_BUTTON_SUNSET};
            padding: 8px 15px;
            border-radius: 10px;
        }}
        QPushButton:hover {{
            background-color: #FF7043;
        }}
        QPushButton:pressed {{
            background-color: #E64A19;
        }}
        QListWidget, QTreeWidget {{
            background-color: {BG_ITEM_SUNSET};
            color: {WHITE};
            border-radius: 8px;
            outline: none;
            padding: 5px;
            border: 1px solid {BORDER_ITEM_SUNSET};
            show-decoration-selected: 0;
        }}
        QListWidget::item, QTreeWidget::item {{
            padding: 6px;
            border-radius: 6px;
            margin: 1px 5px;
        }}
        QListWidget::item:hover, QTreeWidget::item:hover {{
            background-color: #4F4F4F;
        }}
        QListWidget::item:selected, QTreeWidget::item:selected {{
            background-color: {BG_ITEM_SELECTED_SUNSET};
            color: {BLACK};
            font-weight: bold;
        }}
        QScrollBar:vertical {{
            border: none;
            background: transparent;
            width: 8px;
            margin: 0px;
        }}
        QScrollBar::handle:vertical {{
            background: #FF7043;
            min-height: 20px;
            border-radius: 4px;
        }}
        QScrollBar::add-line:vertical, QScrollBar::sub-line:vertical {{
            height: 0px;
        }}
        QScrollBar::add-page:vertical, QScrollBar::sub-page:vertical {{
            background: none;
        }}
    """
}
