/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceSaveableComparison;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SaveablesCompareEditorInput;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.services.IDisposable;

public abstract class SaveableCompareEditorInput
extends CompareEditorInput
implements ISaveablesSource {
    private ICompareInputChangeListener compareInputChangeListener;
    private final IWorkbenchPage page;
    private final ListenerList<ICompareInputChangeListener> inputChangeListeners = new ListenerList(1);
    private Saveable saveable;
    private IPropertyListener propertyListener;

    public static ITypedElement createFileElement(IFile file) {
        return new LocalResourceTypedElement((IResource)file);
    }

    private static ITypedElement getFileElement(ICompareInput input, CompareEditorInput editorInput) {
        if (input.getLeft() instanceof LocalResourceTypedElement) {
            return input.getLeft();
        }
        if (editorInput instanceof CompareFileRevisionEditorInput) {
            return ((CompareFileRevisionEditorInput)editorInput).getLocalElement();
        }
        return null;
    }

    public SaveableCompareEditorInput(CompareConfiguration configuration, IWorkbenchPage page) {
        super(configuration);
        this.page = page;
        if (Policy.DEBUG_COMPARE_EDITOR_INPUT) {
            this.logTrace("constructed");
        }
    }

    protected void contentsCreated() {
        super.contentsCreated();
        if (Policy.DEBUG_COMPARE_EDITOR_INPUT) {
            this.logTrace("compareInputChangeListener assigned");
            this.logStackTrace();
        }
        this.compareInputChangeListener = source -> {
            if (source == this.getCompareResult()) {
                boolean closed = false;
                if (source.getKind() == 0) {
                    closed = this.closeEditor(true);
                }
                if (!closed) {
                    this.propogateInputChange();
                }
            }
        };
        this.getCompareInput().addCompareInputChangeListener(this.compareInputChangeListener);
        if (this.getSaveable() instanceof SaveableComparison) {
            SaveableComparison scm = (SaveableComparison)this.saveable;
            this.propertyListener = (source, propId) -> {
                if (propId == 257) {
                    this.setDirty(this.saveable.isDirty());
                }
            };
            scm.addPropertyListener(this.propertyListener);
        }
        this.setDirty(this.saveable.isDirty());
    }

    private ISaveablesLifecycleListener getSaveablesLifecycleListener(IWorkbenchPart part) {
        ISaveablesLifecycleListener listener = (ISaveablesLifecycleListener)Adapters.adapt((Object)part, ISaveablesLifecycleListener.class);
        if (listener == null) {
            listener = (ISaveablesLifecycleListener)part.getSite().getService(ISaveablesLifecycleListener.class);
        }
        return listener;
    }

    protected void handleDispose() {
        Saveable saveable;
        if (Policy.DEBUG_COMPARE_EDITOR_INPUT) {
            this.logTrace("handleDispose()");
            this.logStackTrace();
        }
        super.handleDispose();
        ICompareInput compareInput = this.getCompareInput();
        if (compareInput != null) {
            if (this.compareInputChangeListener != null) {
                compareInput.removeCompareInputChangeListener(this.compareInputChangeListener);
            } else if (Policy.DEBUG_COMPARE_EDITOR_INPUT) {
                this.logTrace("compareInputChangeListener is unexpectedly null!");
                this.logStackTrace();
            }
        }
        if (Policy.DEBUG_COMPARE_EDITOR_INPUT) {
            this.logTrace("compareInputChangeListener = null");
        }
        this.compareInputChangeListener = null;
        Saveable saveable2 = this.saveable;
        if (saveable2 instanceof SaveableComparison) {
            SaveableComparison scm = (SaveableComparison)saveable2;
            if (this.propertyListener != null) {
                scm.removePropertyListener(this.propertyListener);
                this.propertyListener = null;
            }
        }
        if ((saveable = this.saveable) instanceof LocalResourceSaveableComparison) {
            LocalResourceSaveableComparison rsc = (LocalResourceSaveableComparison)saveable;
            rsc.dispose();
        }
        if (this.getCompareResult() instanceof IDisposable) {
            ((IDisposable)this.getCompareResult()).dispose();
        }
    }

    private void logStackTrace() {
        new Exception("<Fake exception> in " + ((Object)((Object)this)).getClass().getName()).printStackTrace(System.out);
    }

    private void logTrace(String string) {
        System.out.println("SaveableCompareEditorInput " + System.identityHashCode((Object)this) + ": " + string);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICompareInput input = this.prepareCompareInput(monitor);
        if (input != null) {
            this.setTitle(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object)input.getName()));
        }
        return input;
    }

    protected abstract ICompareInput prepareCompareInput(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    protected final ICompareInput getCompareInput() {
        return (ICompareInput)this.getCompareResult();
    }

    protected abstract void fireInputChange();

    protected boolean closeEditor(boolean checkForUnsavedChanges) {
        if (this.isSaveNeeded() && checkForUnsavedChanges) {
            return false;
        }
        IWorkbenchPage page = this.getPage();
        if (page == null) {
            return false;
        }
        Runnable runnable = () -> {
            Shell shell = page.getWorkbenchWindow().getShell();
            if (shell == null) {
                return;
            }
            IEditorPart part = page.findEditor((IEditorInput)this);
            this.getPage().closeEditor(part, false);
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Shell shell = page.getWorkbenchWindow().getShell();
            if (shell == null) {
                return false;
            }
            Display display = shell.getDisplay();
            display.asyncExec(runnable);
        }
        return true;
    }

    private IWorkbenchPage getPage() {
        if (this.page == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return this.page;
    }

    void propogateInputChange() {
        if (!this.inputChangeListeners.isEmpty()) {
            Object[] allListeners;
            Object[] objectArray = allListeners = this.inputChangeListeners.getListeners();
            int n = allListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)l;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)SaveableCompareEditorInput.this.getCompareResult());
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++n2;
            }
        }
    }

    protected Saveable getSaveable() {
        if (this.saveable == null) {
            this.saveable = this.createSaveable();
        }
        return this.saveable;
    }

    protected Saveable createSaveable() {
        Object compareResult = this.getCompareResult();
        Assert.isNotNull((Object)compareResult, (String)"This method cannot be called until after prepareInput is called");
        return new InternalResourceSaveableComparison((ICompareInput)compareResult, this);
    }

    public Saveable[] getActiveSaveables() {
        if (this.getCompareResult() == null) {
            return new Saveable[0];
        }
        return new Saveable[]{this.getSaveable()};
    }

    public Saveable[] getSaveables() {
        return this.getActiveSaveables();
    }

    public void addCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.add((Object)listener);
        } else {
            super.addCompareInputChangeListener(input, listener);
        }
    }

    public void removeCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.remove((Object)listener);
        } else {
            super.removeCompareInputChangeListener(input, listener);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        IResource resource;
        if (IFile.class.equals(adapter) && (resource = Utils.getResource(this.getCompareResult())) instanceof IFile) {
            return (T)resource;
        }
        return (T)super.getAdapter(adapter);
    }

    public Image getTitleImage() {
        ImageRegistry reg = TeamUIPlugin.getPlugin().getImageRegistry();
        Image image = reg.get("eview16/synch_synch.svg");
        if (image == null) {
            image = this.getImageDescriptor().createImage();
            reg.put("eview16/synch_synch.svg", image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor() {
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.svg");
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier) {
            IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            Saveable saveable = this.saveable;
            if (saveable instanceof IPropertyChangeListener) {
                IPropertyChangeListener pcl = (IPropertyChangeListener)saveable;
                dsp.addPropertyChangeListener(pcl);
                Control c = newViewer.getControl();
                c.addDisposeListener(e -> dsp.removePropertyChangeListener(pcl));
            }
        }
        return newViewer;
    }

    public boolean canRunAsJob() {
        return true;
    }

    public boolean isDirty() {
        if (this.saveable != null) {
            return this.saveable.isDirty();
        }
        return super.isDirty();
    }

    public void registerContextMenu(MenuManager menu, ISelectionProvider selectionProvider) {
        super.registerContextMenu(menu, selectionProvider);
        Saveable saveable = this.getSaveable();
        if (saveable instanceof LocalResourceSaveableComparison) {
            ITypedElement element = SaveableCompareEditorInput.getFileElement(this.getCompareInput(), this);
            menu.addMenuListener(manager -> SaveablesCompareEditorInput.handleMenuAboutToShow(manager, this.getContainer(), saveable, element, selectionProvider));
        }
    }

    private class InternalResourceSaveableComparison
    extends LocalResourceSaveableComparison
    implements EditableSharedDocumentAdapter.ISharedDocumentAdapterListener {
        private LocalResourceTypedElement lrte;
        private boolean connected;

        public InternalResourceSaveableComparison(ICompareInput input, CompareEditorInput editorInput) {
            super(input, editorInput, SaveableCompareEditorInput.getFileElement(input, editorInput));
            ITypedElement element = SaveableCompareEditorInput.getFileElement(input, editorInput);
            if (element instanceof LocalResourceTypedElement) {
                this.lrte = (LocalResourceTypedElement)element;
                if (this.lrte.isConnected()) {
                    this.registerSaveable(true);
                } else {
                    this.lrte.setSharedDocumentListener(this);
                }
            }
        }

        @Override
        protected void fireInputChange() {
            SaveableCompareEditorInput.this.fireInputChange();
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.lrte != null) {
                this.lrte.setSharedDocumentListener(null);
            }
        }

        @Override
        public void handleDocumentConnected() {
            if (this.connected) {
                return;
            }
            this.connected = true;
            this.registerSaveable(false);
            if (this.lrte != null) {
                this.lrte.setSharedDocumentListener(null);
            }
        }

        private void registerSaveable(boolean init) {
            ICompareContainer container = SaveableCompareEditorInput.this.getContainer();
            IWorkbenchPart part = container.getWorkbenchPart();
            if (part != null) {
                ISaveablesLifecycleListener lifecycleListener = SaveableCompareEditorInput.this.getSaveablesLifecycleListener(part);
                if (!init) {
                    lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 3, new Saveable[]{this}, false));
                }
                this.initializeHashing();
                lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)part, 1, new Saveable[]{this}, false));
            }
        }

        @Override
        public void handleDocumentDeleted() {
        }

        @Override
        public void handleDocumentDisconnected() {
        }

        @Override
        public void handleDocumentFlushed() {
        }

        @Override
        public void handleDocumentSaved() {
        }
    }
}

