package Mojo::Util::Model;
use Mojo::Base -base;

our $VERSION = '0.0.7';

use Mojo::JSON qw(encode_json);

has 'exists' => sub {
    return shift->pk ? 1 : 0;
};

has 'id';

has 'keys_to_serialize' => sub {
    my $self = shift;

    my @keys = keys(%$self);

    return \@keys;
};

has 'pk' => sub {
    my $self = shift;

    return $self->get($self->primary_key);
};

has 'primary_key' => 'id';

sub get {
    my ($self, $field, $default) = @_;

    my $value = undef;
    $default //= undef;

    my @pieces = split(/\./, $field);

    if (scalar(@pieces) > 1) {
        $field = shift @pieces;

        if ($self->can($field)) {
            if (ref($self->$field) eq 'HASH') {
                my $tmp = $self->$field;

                while (ref($tmp)  eq 'HASH') {
                    $field = shift @pieces;
                    $tmp = $tmp->{ $field };
                }

                return $tmp || $default;
            }

            return $self->$field->get(join('.', @pieces), $default);
        }

        return $default;
    }

    if ($self->can($field)) {
        $value = $self->$field;
    } else {
        $value = $self->{ $field } if (exists $self->{ $field });
    }

    return $value // $default;
}

sub serialize {
    my $self = shift;

    my $result = {
        exists      => $self->exists,
        id          => $self->pk,
        primary_key => $self->primary_key,
    };

    $result->{ $_ } = $self->get($_) for (@{ $self->keys_to_serialize });

    return $result;
}

sub toCsv {
    my ($self, $columns, $options) = @_;

    my $default = defined($options->{ default }) ? $options->{ default } : 'n/a';
    my $quote_char = $options->{ quote_char } // '"';

    my @array;

    foreach my $column (@$columns) {
        push(@array, sprintf('%s%s%s', $quote_char, $self->get($column, $default), $quote_char));
    }

    return join(',', @array);
}

sub toJson {
    return encode_json(shift->serialize);
}

sub AUTOLOAD {
    my $self = shift;
    our $AUTOLOAD;
    my $field = $AUTOLOAD =~ /::(\w+)$/ ? $1 : undef;

    $field =~ s/.*:://;
    return unless $field =~ /[^A-Z]/; # skip DESTROY and all-cap methods

    return $self->get($field) if (exists $self->{ $field });

    die "Undefined method $AUTOLOAD";
}

1;
