/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Sets {
    private Sets() {
    }

    public static <E, F> Set<Pair<E, F>> cross(Set<E> s1, Set<F> s2) {
        HashSet<Pair<Pair<E, F>, F>> s = new HashSet<Pair<Pair<E, F>, F>>();
        for (E o1 : s1) {
            for (F o2 : s2) {
                s.add(new Pair<E, F>(o1, o2));
            }
        }
        return s;
    }

    public static <E> Set<E> diff(Set<E> s1, Set<E> s2) {
        HashSet<E> s = new HashSet<E>();
        for (E o : s1) {
            if (s2.contains(o)) continue;
            s.add(o);
        }
        return s;
    }

    public static <E> Set<E> symmetricDiff(Set<E> s1, Set<E> s2) {
        HashSet<E> s = new HashSet<E>();
        for (E o : s1) {
            if (s2.contains(o)) continue;
            s.add(o);
        }
        for (E o : s2) {
            if (s1.contains(o)) continue;
            s.add(o);
        }
        return s;
    }

    public static <E> Set<E> union(Set<E> s1, Set<E> s2) {
        HashSet<E> s = new HashSet<E>();
        s.addAll(s1);
        s.addAll(s2);
        return s;
    }

    public static <E> Set<E> intersection(Set<E> s1, Set<E> s2) {
        HashSet<E> s = new HashSet<E>();
        s.addAll(s1);
        s.retainAll(s2);
        return s;
    }

    public static <E> boolean intersects(Set<E> s1, Set<E> s2) {
        return !Collections.disjoint(s1, s2);
    }

    public static <E> Set<Set<E>> powerSet(Set<E> s) {
        if (s.isEmpty()) {
            HashSet h = new HashSet();
            HashSet h0 = new HashSet(0);
            h.add(h0);
            return h;
        }
        Iterator<E> i = s.iterator();
        E elt = i.next();
        s.remove(elt);
        Set<Set<Set<E>>> pow = Sets.powerSet(s);
        Set<Set<E>> pow1 = Sets.powerSet(s);
        for (Set<E> t : pow1) {
            t.add(elt);
            pow.add(t);
        }
        s.add(elt);
        return pow;
    }

    public static void main(String[] args) {
        HashSet<String> h = new HashSet<String>();
        h.add("a");
        h.add("b");
        h.add("c");
        Set pow = Sets.powerSet(h);
        System.out.println(pow);
    }
}

