/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.RandomWalk;
import edu.stanford.nlp.util.Index;

public class ChineseLexicon
extends BaseLexicon {
    private static final long serialVersionUID = -7836464391021114960L;
    public final boolean useCharBasedUnknownWordModel;
    public final boolean useGoodTuringUnknownWordModel;
    private static final int STEPS = 1;
    private RandomWalk probRandomWalk;

    public ChineseLexicon(Options op, ChineseTreebankParserParams params, Index<String> wordIndex, Index<String> tagIndex) {
        super(op, wordIndex, tagIndex);
        this.useCharBasedUnknownWordModel = params.useCharBasedUnknownWordModel;
        this.useGoodTuringUnknownWordModel = params.useGoodTuringUnknownWordModel;
    }

    @Override
    public float score(IntTaggedWord iTW, int loc, String word, String featureSpec) {
        boolean seen;
        double c_W = this.seenCounter.getCount(iTW);
        boolean bl = seen = c_W > 0.0;
        if (seen) {
            return super.score(iTW, loc, word, featureSpec);
        }
        float score = this.getUnknownWordModel().score(iTW, loc, 0.0, 0.0, 0.0, word);
        return score;
    }
}

