package Daje::Workflow::Activities::Tools::Generate::SQL;
use Mojo::Base 'Daje::Workflow::Activities::Tools::Generate::Base', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Workflow::Activities::Tools::Generate::SQL - Generate SQL
# migration files for Mojo::Pg
#
# SYNOPSIS
# ========
#
#     use Daje::Workflow::Activities::Tools::Generate::SQL
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Activities::Tools::Generate::SQL is a module that generates SQL
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Daje::Database::View::VToolsParameterValues;

use Daje::Database::View::VToolsVersion;
use Daje::Database::View::VToolsObjectsTypes;
use Daje::Database::View::VToolsObjectsTables;
use Daje::Database::Helper::LoadParameters;
use Daje::Database::View::VToolsObjectsSql;

use POSIX;
use Mojo::Util qw { camelize };
use Data::Dumper;


has 'sqls';

sub generate_sql($self) {
    my @data;
    $self->model->insert_history(
     "Generate SQL",
     "Daje::Workflow::Activity::Tools::Generate::SQL::generate_sql",
     1
    );

    try {
        my $tools_projects_pkey = $self->context->{context}->{payload}->{tools_projects_fkey};
        if ($self->load_generate_data($tools_projects_pkey)) {
            my $source = $self->get_parameter('Sql', 'Template Source', $tools_projects_pkey);
            my $documents = $self->build_documents($source,'sql');
            my $length = scalar @{$documents};
            for (my $i = 0; $i < $length; $i++) {
                my $data->{data} = @{$documents}[$i]->{document};
                my $filename = $self->get_parameter('Sql', 'Output file name', $tools_projects_pkey);
                $data->{file} = $self->get_parameter('Sql', 'Output Path', $tools_projects_pkey) . '/' . $filename;
                $data->{path} = 1;
                push(@data, $data);
            }
            $self->context->{context}->{payload}->{sql} = \@data;
        }
    } catch ($e) {
        say $e
        $self->error->add_error($e);
    };
}

sub load_generate_data($self, $tools_projects_pkey) {
    my $versions;
    my $version;

    if ($self->load_versions($tools_projects_pkey)) {
        my $length = scalar @{$self->versions};
        for (my $i = 0; $i < $length; $i++) {
            my $data->{version} = @{$self->versions}[$i]->{version};
            if ($self->load_tables($tools_projects_pkey, @{$self->versions}[$i]->{tools_version_pkey})) {
                my $tables;
                my $len = scalar @{$self->tables};
                for (my $j = 0; $j < $len; $j++) {
                    my $table = $self->process_table(@{$self->tables}[$j], @{$self->versions}[$i]);
                    push @{$tables}, $table;
                }
                $data->{tables} = $tables;
            }

            if ($self->load_sql($tools_projects_pkey, @{$self->versions}[$i]->{tools_version_pkey})) {
                my $sqls;
                my $len = scalar @{$self->sqls};
                for (my $k = 0; $k < $len; $k++) {
                    my $sql = $self->process_sql(@{$self->sqls}[$k], @{$self->versions}[$i]);
                    my $lent = scalar @{$sql};
                    for(my $l = 0; $l < $lent; $l++) {
                        push @{$sqls}, @{$sql}[$l];
                    }
                }
                $data->{sql} = $sqls;
            }
            push @{$version}, $data;
        }
        $versions->{versions} = $version;
        $versions->{data_sectioner} = "__DATA__";
        $versions->{date_time} = strftime "%Y-%m-%d %H:%M:%S", localtime time;
        $versions->{project_name} = $self->load_project_name($tools_projects_pkey);
        $versions->{section_name} = '@@ ' . $self->load_project_name($tools_projects_pkey);
        $versions->{name_space} = $self->get_parameter('Sql', 'Output Name Space', $tools_projects_pkey);
        $self->versions($versions);
    }
    return 1;
}

sub process_sql($self, $sql, $tools_version) {
    my $sql_rec = Daje::Database::View::VToolsObjectsSql->new(
        db => $self->db
    )->load_objects_sql(
        $sql->{tools_objects_pkey}, $tools_version->{tools_version_pkey}
    );

    return $sql_rec->{data};
}

sub load_sql($self, $tools_projects_pkey,$tools_version_pkey) {
    my $sqls = $self->load_objects_from_type(3, $tools_projects_pkey, $tools_version_pkey);
    my $sql = $sqls->{data};
    $self->sqls($sql);
    return $sqls->{result};
}

1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Activities::Tools::Generate::SQL - Generate SQL
migration files for Mojo::Pg



=head1 SYNOPSIS


    use Daje::Workflow::Activities::Tools::Generate::SQL



=head1 DESCRIPTION


Daje::Workflow::Activities::Tools::Generate::SQL is a module that generates SQL



=head1 REQUIRES

L<Daje::Document::Builder> 

L<Data::Dumper> 

L<v5.42> 

L<Mojo::Base> 


=head1 METHODS

=head2 build_documents

 build_documents();

=head2 generate_sql($self)

 generate_sql($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

