/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.salt.Cell;
import net.sourceforge.plantuml.salt.element.Segment;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Grid {
    private final double[] rowsStart;
    private final double[] colsStart;
    private final TableStrategy strategy;
    private final Set<Segment> horizontals = new HashSet<Segment>();
    private final Set<Segment> verticals = new HashSet<Segment>();

    public Grid(double[] dArray, double[] dArray2, TableStrategy tableStrategy) {
        this.rowsStart = dArray;
        this.colsStart = dArray2;
        this.strategy = tableStrategy;
        if (tableStrategy == TableStrategy.DRAW_OUTSIDE || tableStrategy == TableStrategy.DRAW_ALL) {
            this.addOutside();
        }
    }

    private void addOutside() {
        int n;
        int n2 = this.rowsStart.length;
        int n3 = this.colsStart.length;
        for (n = 0; n < n3 - 1; ++n) {
            this.horizontals.add(new Segment(0, n));
            this.horizontals.add(new Segment(n2 - 1, n));
        }
        for (n = 0; n < n2 - 1; ++n) {
            this.verticals.add(new Segment(n, 0));
            this.verticals.add(new Segment(n, n3 - 1));
        }
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        double d3;
        int n;
        int n2;
        for (Segment segment : this.horizontals) {
            n2 = segment.getRow();
            n = segment.getCol();
            d3 = this.colsStart[n + 1] - this.colsStart[n];
            uGraphic.apply(new UTranslate(d + this.colsStart[n], d2 + this.rowsStart[n2])).draw(new ULine(d3, 0.0));
        }
        for (Segment segment : this.verticals) {
            n2 = segment.getRow();
            n = segment.getCol();
            d3 = this.rowsStart[n2 + 1] - this.rowsStart[n2];
            uGraphic.apply(new UTranslate(d + this.colsStart[n], d2 + this.rowsStart[n2])).draw(new ULine(0.0, d3));
        }
    }

    public void addCell(Cell cell) {
        int n;
        if (this.strategy == TableStrategy.DRAW_NONE) {
            return;
        }
        if (this.strategy == TableStrategy.DRAW_OUTSIDE) {
            return;
        }
        if (this.strategy == TableStrategy.DRAW_HORIZONTAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (n = cell.getMinCol(); n <= cell.getMaxCol(); ++n) {
                this.horizontals.add(new Segment(cell.getMinRow(), n));
                this.horizontals.add(new Segment(cell.getMaxRow() + 1, n));
            }
        }
        if (this.strategy == TableStrategy.DRAW_VERTICAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (n = cell.getMinRow(); n <= cell.getMaxRow(); ++n) {
                this.verticals.add(new Segment(n, cell.getMinCol()));
                this.verticals.add(new Segment(n, cell.getMaxCol() + 1));
            }
        }
    }
}

