/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.Tree;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEval {
    private static final boolean DEBUG = false;
    protected final String str;
    protected final boolean runningAverages;
    private double precision = 0.0;
    private double recall = 0.0;
    private double f1 = 0.0;
    protected double num = 0.0;
    private double exact = 0.0;
    private double precision2 = 0.0;
    private double recall2 = 0.0;
    private double pnum2 = 0.0;
    private double rnum2 = 0.0;
    protected double curF1 = 0.0;

    public AbstractEval() {
        this(true);
    }

    public AbstractEval(boolean runningAverages) {
        this("", runningAverages);
    }

    public AbstractEval(String str) {
        this(str, true);
    }

    public AbstractEval(String str, boolean runningAverages) {
        this.str = str;
        this.runningAverages = runningAverages;
    }

    public double getSentAveF1() {
        return this.f1 / this.num;
    }

    public double getEvalbF1() {
        return 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
    }

    public double getLastF1() {
        return this.curF1 * 100.0;
    }

    public double getEvalbF1Percent() {
        return this.getEvalbF1() * 100.0;
    }

    public double getExact() {
        return this.exact / this.num;
    }

    public double getExactPercent() {
        return this.getExact() * 100.0;
    }

    public int getNum() {
        return (int)this.num;
    }

    protected static double precision(Set<?> s1, Set<?> s2) {
        double n = 0.0;
        double p = 0.0;
        for (Object o1 : s1) {
            if (s2.contains(o1)) {
                p += 1.0;
            }
            n += 1.0;
        }
        return n > 0.0 ? p / n : 0.0;
    }

    protected abstract Set<?> makeObjects(Tree var1);

    public void evaluate(Tree guess, Tree gold) {
        this.evaluate(guess, gold, new PrintWriter(System.out, true));
    }

    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        this.evaluate(guess, gold, pw, 1.0);
    }

    public void evaluate(Tree guess, Tree gold, PrintWriter pw, double weight) {
        Set<?> dep1 = this.makeObjects(guess);
        Set<?> dep2 = this.makeObjects(gold);
        double curPrecision = AbstractEval.precision(dep1, dep2);
        double curRecall = AbstractEval.precision(dep2, dep1);
        this.curF1 = curPrecision > 0.0 && curRecall > 0.0 ? 2.0 / (1.0 / curPrecision + 1.0 / curRecall) : 0.0;
        this.precision += curPrecision * weight;
        this.recall += curRecall * weight;
        this.f1 += this.curF1 * weight;
        this.num += weight;
        this.precision2 += (double)dep1.size() * curPrecision * weight;
        this.pnum2 += (double)dep1.size() * weight;
        this.recall2 += (double)dep2.size() * curRecall * weight;
        this.rnum2 += (double)dep2.size() * weight;
        if (this.curF1 > 0.9999) {
            this.exact += 1.0;
        }
        if (pw != null) {
            pw.print(" P: " + (double)((int)(curPrecision * 10000.0)) / 100.0);
            if (this.runningAverages) {
                pw.println(" (sent ave " + (double)((int)(this.precision * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.precision2 * 10000.0 / this.pnum2)) / 100.0 + ")");
            }
            pw.print(" R: " + (double)((int)(curRecall * 10000.0)) / 100.0);
            if (this.runningAverages) {
                pw.print(" (sent ave " + (double)((int)(this.recall * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.recall2 * 10000.0 / this.rnum2)) / 100.0 + ")");
            }
            pw.println();
            double cF1 = 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
            pw.print(this.str + " F1: " + (double)((int)(this.curF1 * 10000.0)) / 100.0);
            if (this.runningAverages) {
                pw.print(" (sent ave " + (double)((int)(10000.0 * this.f1 / this.num)) / 100.0 + ", evalb " + (double)((int)(10000.0 * cF1)) / 100.0 + ")   Exact: " + (double)((int)(10000.0 * this.exact / this.num)) / 100.0);
            }
            pw.println(" N: " + this.num);
        }
    }

    public void display(boolean verbose) {
        this.display(verbose, new PrintWriter(System.out, true));
    }

    public void display(boolean verbose, PrintWriter pw) {
        double prec = this.precision2 / this.pnum2;
        double rec = this.recall2 / this.rnum2;
        double f = 2.0 / (1.0 / prec + 1.0 / rec);
        pw.println(this.str + " summary evalb: LP: " + (double)((int)(10000.0 * prec)) / 100.0 + " LR: " + (double)((int)(10000.0 * rec)) / 100.0 + " F1: " + (double)((int)(10000.0 * f)) / 100.0 + " Exact: " + (double)((int)(10000.0 * this.exact / this.num)) / 100.0 + " N: " + this.getNum());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScoreEval
    extends AbstractEval {
        double totScore = 0.0;
        double n = 0.0;
        NumberFormat nf = new DecimalFormat("0.000");

        @Override
        protected Set<?> makeObjects(Tree tree) {
            return null;
        }

        public void recordScore(KBestViterbiParser parser, PrintWriter pw) {
            double score = parser.getBestScore();
            this.totScore += score;
            this.n += 1.0;
            if (pw != null) {
                pw.print(this.str + " score: " + this.nf.format(score));
                if (this.runningAverages) {
                    pw.print(" average score: " + this.nf.format(this.totScore / this.n));
                }
                pw.println();
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            if (pw != null) {
                pw.println(this.str + " total score: " + this.nf.format(this.totScore) + " average score: " + (this.n == 0.0 ? "N/A" : this.nf.format(this.totScore / this.n)));
            }
        }

        public ScoreEval(String str, boolean runningAverages) {
            super(str, runningAverages);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CatErrorEval
    extends AbstractEval {
        private ClassicCounter<String> over = new ClassicCounter();
        private ClassicCounter<String> under = new ClassicCounter();

        @Override
        protected Set<?> makeObjects(Tree tree) {
            return null;
        }

        private static List<String> myMakeObjects(Tree tree) {
            LinkedList<String> cats = new LinkedList<String>();
            for (Tree st : tree.subTreeList()) {
                cats.add(st.value());
            }
            return cats;
        }

        @Override
        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            List<String> s1 = CatErrorEval.myMakeObjects(t1);
            List<String> s2 = CatErrorEval.myMakeObjects(t2);
            LinkedList<String> del2 = new LinkedList<String>(s2);
            for (String o1 : s1) {
                if (del2.remove(o1)) continue;
                this.over.incrementCount(o1);
            }
            for (String o2 : s2) {
                if (s1.remove(o2)) continue;
                this.under.incrementCount(o2);
            }
        }

        private static <T> void display(ClassicCounter<T> c, PrintWriter pw) {
            ArrayList<T> cats = new ArrayList<T>(c.keySet());
            Collections.sort(cats, Counters.toComparatorDescending(c));
            for (Object ob : cats) {
                pw.println(ob + " " + c.getCount(ob));
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            pw.println("Most frequently underproposed categories:");
            CatErrorEval.display(this.under, pw);
            pw.println("Most frequently overproposed categories:");
            CatErrorEval.display(this.over, pw);
        }

        public CatErrorEval(String str) {
            super(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleErrorEval
    extends AbstractEval {
        private ClassicCounter<String> over = new ClassicCounter();
        private ClassicCounter<String> under = new ClassicCounter();

        protected static String localize(Tree tree) {
            if (tree.isLeaf()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(tree.label());
            sb.append(" ->");
            for (int i = 0; i < tree.children().length; ++i) {
                sb.append(' ');
                sb.append(tree.children()[i].label());
            }
            return sb.toString();
        }

        protected Set<String> makeObjects(Tree tree) {
            HashSet<String> localTrees = new HashSet<String>();
            for (Tree st : tree.subTreeList()) {
                localTrees.add(RuleErrorEval.localize(st));
            }
            return localTrees;
        }

        @Override
        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            Set<String> s1 = this.makeObjects(t1);
            Set<String> s2 = this.makeObjects(t2);
            for (String o1 : s1) {
                if (s2.contains(o1)) continue;
                this.over.incrementCount(o1);
            }
            for (String o2 : s2) {
                if (s1.contains(o2)) continue;
                this.under.incrementCount(o2);
            }
        }

        private static <T> void display(ClassicCounter<T> c, int num, PrintWriter pw) {
            ArrayList<T> rules = new ArrayList<T>(c.keySet());
            Collections.sort(rules, Counters.toComparatorDescending(c));
            int rSize = rules.size();
            if (num > rSize) {
                num = rSize;
            }
            for (int i = 0; i < num; ++i) {
                pw.println(rules.get(i) + " " + c.getCount(rules.get(i)));
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            pw.println("Most frequently underproposed rules:");
            RuleErrorEval.display(this.under, verbose ? 100 : 10, pw);
            pw.println("Most frequently overproposed rules:");
            RuleErrorEval.display(this.over, verbose ? 100 : 10, pw);
        }

        public RuleErrorEval(String str) {
            super(str);
        }
    }
}

